% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{AICc}
\alias{AICc}
\title{Corrected Akaike's Information Criterion}
\usage{
AICc(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some stuff.}
}
\value{
This function returns numeric value.
}
\description{
This function extracts AICc from models. Can be applied to wide variety of
models that use logLik() and nobs() methods (including the popular lm,
forecast, smooth).
}
\details{
AICc was proposed by Nariaki Sugiura in 1978 and is used on small samples
for the models with normally distributed residuals.
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

ourModel <- stepwise(xreg)

AICc(ourModel,h=10)

}
\references{
Kenneth P. Burnham, David R. Anderson (1998). Model Selection
and Multimodel Inference. Springer Science & Business Media.
}
\seealso{
\link[stats]{AIC}, \link[stats]{BIC}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
