% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimisation.R
\name{optimise_registration_params}
\alias{optimise_registration_params}
\title{Optimise registration parameters with Simulated Annealing}
\usage{
optimise_registration_params(
  input_df,
  genes = NULL,
  stretches_bound = NA,
  shifts_bound = NA,
  initial_rescale = FALSE,
  do_rescale = TRUE,
  min_num_overlapping_points = 4,
  maintain_min_num_overlapping_points = FALSE,
  accession_data_to_transform,
  accession_data_ref,
  start_timepoint = c("reference", "transform", "zero"),
  expression_value_threshold = 5,
  is_data_normalised = FALSE,
  num_iterations = 60
)
}
\arguments{
\item{input_df}{Input data frame containing all replicates of gene expression in each genotype at each time point.}

\item{genes}{List of genes to optimise.}

\item{stretches_bound}{Optional candidate registration stretch factors define search space, otherwise automatic.}

\item{shifts_bound}{Optional candidate registration shift values to define search space, otherwise automatic.}

\item{initial_rescale}{Scaling gene expression prior to registration if \code{TRUE}.}

\item{do_rescale}{Scaling gene expression using only overlapping time points points during registration.}

\item{min_num_overlapping_points}{Number of minimum overlapping time points. Shifts will be only considered if it leaves at least these many overlapping points after applying the registration function.}

\item{maintain_min_num_overlapping_points}{Whether to automatically calculate extreme (minimum and maximum) values of \code{shifts} to maintain specified \code{min_num_overlapping_points} condition. By default, \code{FALSE}.}

\item{accession_data_to_transform}{Accession name of data which will be transformed.}

\item{accession_data_ref}{Accession name of reference data.}

\item{start_timepoint}{Time points to be added in both reference data and data to transform after shifting and stretching. Can be either \code{"reference"} (the default), \code{"transform"}, or \code{"zero"}.}

\item{expression_value_threshold}{Expression value threshold. Remove expressions if maximum is less than the threshold. If \code{NULL} keep all data.}

\item{is_data_normalised}{\code{TRUE} if dataset has been normalised prior to registration process.}

\item{num_iterations}{Maximum number of iterations of the algorithm. Default is 100.}
}
\value{
List of optimum registration parameters, \code{optimum_params_df}, and other candidate registration parameters, \code{candidate_params_df} for all genes.
}
\description{
Optimise registration parameters with Simulated Annealing
}
