% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoweek-class.R
\name{isoweek_class}
\alias{isoweek_class}
\alias{isoweek}
\alias{as_isoweek}
\alias{as_isoweek.default}
\alias{as_isoweek.Date}
\alias{as_isoweek.POSIXt}
\alias{as_isoweek.character}
\alias{as_isoweek.factor}
\alias{new_isoweek}
\alias{is_isoweek}
\title{ISO Week class}
\usage{
isoweek(year = integer(), week = integer())

as_isoweek(x, ...)

\method{as_isoweek}{default}(x, ...)

\method{as_isoweek}{Date}(x, ...)

\method{as_isoweek}{POSIXt}(x, ...)

\method{as_isoweek}{character}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)

\method{as_isoweek}{factor}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)

new_isoweek(x = integer())

is_isoweek(xx)
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{week}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{week}{\verb{[integer]}

Vector representing the week associated with `year.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{x, xx}{\R objects.}

\item{...}{Other values passed to as.Date().}

\item{format}{\verb{[character]}

Passed to as.Date() unless \code{format = "yearweek"} in which case input is
assumed to be in the form "YYYY-Wxx".

If not specified, it will try tryFormats one by one on the first non-NA
element, and give an error if none works. Otherwise, the processing is via
\code{strptime()} whose help page describes available conversion specifications.}

\item{tryFormats}{\verb{[character]}

Format strings to try if format is not specified.}
}
\value{
A \verb{<grates_isoweek>} object.
}
\description{
\verb{<grates_isoweek>} objects are used to represent ISO week dates as defined in
\href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601}. To expand further, it is
easiest to quote from the related
\href{https://en.wikipedia.org/w/index.php?title=ISO_week_date&oldid=1269568343}{wikipedia entry}:

\emph{"ISO weeks start with Monday and end on Sunday. Each week's year is the
Gregorian year in which the Thursday falls. The first week of the year, hence,
always contains 4 January. ISO week year numbering therefore usually
deviates by 1 from the Gregorian for some days close to 1 January."}

Internally, \verb{<grates_isoweek>} objects are stored as the number of weeks
(starting at 0) from the first Monday prior to the Unix Epoch (1970-01-01).
That is, the number of seven day periods from 1969-12-29.
}
\details{
\code{isoweek()} is a constructor for \verb{<grates_isoweek>} objects. It takes a
vector of year and vector of week values as inputs. Length 1 inputs will be
recycled to the length of the other input and \code{double} vectors will again be
converted to integer via \code{as.integer(floor(x))}.

\code{as_isoweek()} is a generic for conversion to \verb{<grates_isoweek>}.
\itemize{
\item Date, POSIXct, and POSIXlt are converted with the timezone respected.
\item Character objects are first coerced to date via \code{as.Date()} unless
\code{format = "yearweek"} in which case input is assumed to be in the form
"YYYY-Wxx" and parsed accordingly.
}

\code{new_isoweek()} is a minimal constructor for \verb{<grates_isoweek>} objects
aimed at developers. It takes, as input, the number of isoweeks since the
Monday prior to the Unix Epoch that you wish to represent. \code{double} vectors
will be converted to integer via \code{as.integer(floor(x))}.
}
\examples{

# date coercion
as_isoweek(Sys.Date())

# POSIXt coercion
as_isoweek(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))

# character coercion assumes date input by default
as_isoweek("2019-05-03")

# character coercion can handle YYYY-Www format too
as_isoweek("2019-W12", format = "yearweek")

# construction
isoweek(year = 2000, week = 3)

# direct construction
stopifnot(
    identical(
        new_isoweek(0:1),
        as_isoweek("1969-12-29") + 0:1
    )
)

}
\references{
Wikipedia contributors. (2025, January 15). ISO week date.
In Wikipedia, The Free Encyclopedia.
Retrieved 09:19, March 6, 2025, from https://en.wikipedia.org/w/index.php?title=ISO_week_date&oldid=1269568343
}
\seealso{
The \link[=yearweek_class]{yearweek} and \link[=epiweek_class]{epiweek} classes.
}
