% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiweek.R
\name{new_epiweek}
\alias{new_epiweek}
\alias{is_epiweek}
\title{Minimal constructor for an epiweek object}
\usage{
new_epiweek(x = integer())

is_epiweek(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of weeks.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{xx}{\R object.}
}
\value{
A \verb{<grates_epiweek>} object.
}
\description{
\code{new_epiweek()} is a constructor for \verb{<grates_epiweek>} objects aimed at
developers.
}
\details{
Epiweeks are defined to start on a Sunday and \verb{<grates_epiweek>} objects are
stored as the number of weeks (starting at 0) from the first Sunday after the
Unix Epoch (1970-01-01). That is, the number of seven day periods from
1970-01-04.

Internally they have the same representation as a \verb{<grates_yearweek_sunday>}
object so are akin to an alias but with a marginally more efficient
implementation.
}
\examples{
new_epiweek(1:10)

}
\seealso{
\code{new_yearweek()} and \code{new_isoweek()}.
}
