% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{make_state_matrix}
\alias{make_state_matrix}
\title{Make State Matrix}
\usage{
make_state_matrix(graph, state = "activating")
}
\arguments{
\item{graph}{An \code{\link[igraph]{igraph}} object. May be directed or weighted as long as
a shortest path can be computed.}

\item{state}{numeric vector. Vector of length E(graph). Sign used to calculate state matrix,
may be an integer state or inferred directly from expected correlations for each edge. May be
applied a scalar across all edges or as a vector for each edge respectively. May also be
entered as text for "activating" or "inhibiting" or as integers for activating (0,1) or
inhibiting (-1,2). Compatible with inputs for \code{\link[graphsim]{plot_directed}}.}
}
\value{
An integer matrix indicating the resolved state
(activating or inhibiting for each edge or path between nodes)
}
\description{
Functions to compute the matrix of states (1 for activating and -1 for inhibiting) 
for link signed correlations, from a vector of edge states to a signed adjacency matrix for use
in \code{\link[graphsim]{generate_expression}}.
}
\examples{

library("igraph")
graph_test_edges <- rbind(c("A", "B"), c("B", "C"), c("B", "D"))
graph_test <- graph.edgelist(graph_test_edges, directed = TRUE)
state_matrix <- make_state_matrix(graph_test)

}
\keyword{graph}
\keyword{igraph}
\keyword{mvtnorm}
\keyword{network}
\keyword{simulation}
