% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmodel.ER.R
\name{gmodel.ER}
\alias{gmodel.ER}
\title{Observations from Erdos-Renyi random graph model}
\usage{
gmodel.ER(n, mode = "prob", par = 0.5, rep = 1)
}
\arguments{
\item{n}{the number of nodes to be generated}

\item{mode}{'prob' (default) for edges to be drawn from Bernoulli
distribution independently, or 'num' for a graph to have a fixed
number of edges placed randomly}

\item{par}{a real number in [0,1] for \code{mode='prob'}, or a
positive integer [1,n*(n-1)/2] for \code{mode='num'}}

\item{rep}{the number of observations to be generated.}
}
\value{
depending on \code{rep} value, either
\describe{
\item{(rep=1)}{an \eqn{(n-by-n)} observation matrix, or}
\item{(rep>1)}{a length-\eqn{rep} list where each element
is an observation is an \eqn{(n-by-n)} realization from the model.}
}
}
\description{
Erdos-Renyi random graph model is one of the most popular and
fundamental examples in modeling networks. Given n nodes,
\code{gmodel.ER} generates edges randomly from Bernoulli distribution
with a globally specified probability.
}
\details{
In network science, 'ER' model is often interchangeably used in where
we have fixed number of edges to be placed at random. The original
use of edge-generating probability is from Gilbert (1959). Therefore,
we set this algorithm to be flexible in that user can create either a
fixed number of edges placed at random or set global edge-generating probability
and draw independent observations following Bernoulli distribution.
}
\examples{
## Generate a graph of 100 nodes with a fixed number of edges
graph1 = gmodel.ER(100,mode='num',par=100)
image(graph1)

## Generate 3 graphs with a global with probability 0.5
graph2 = gmodel.ER(100,par=0.5,rep=3)

par(mfrow=c(1,3))
image(graph2[[1]])
image(graph2[[2]])
image(graph2[[3]])

}
\references{
Erdos, P. and Renyi, A. (1959) \emph{On Random Graphs I}. Publications
Mathematicae, Vol.6:290-297.

Gilbert, E.N. (1959) \emph{Random Graphs}. Annals of Mathematical
Statistics, Vol.30, No.4:1141-1144.
}
