% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_param.R
\name{loglik_HR}
\alias{loglik_HR}
\title{Compute Huesler-Reiss log-likelihood, AIC, and BIC}
\usage{
loglik_HR(data, p = NULL, graph = NULL, Gamma, cens = FALSE)
}
\arguments{
\item{data}{Numeric \nxd matrix. It contains
observations following a multivariate HR Pareto distribution.}

\item{p}{Numeric between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} are already on multivariate Pareto scale.
Else, \code{p} is used as the probability in the function \code{\link[=data2mpareto]{data2mpareto()}}
to standardize the \code{data}.}

\item{graph}{An [\code{igraph::graph}] object or \code{NULL}. The \code{graph} must be undirected and
connected. If no graph is specified, the complete graph is used.}

\item{Gamma}{Numeric \nxd matrix.
It represents a variogram matrix \eGamma.}

\item{cens}{Boolean. If true, then censored log-likelihood is computed.
By default, \code{cens = FALSE}.}
}
\value{
Numeric vector \code{c("loglik"=..., "aic"=..., "bic"=...)} with the evaluated
log-likelihood, AIC, and BIC values.
}
\description{
Computes (censored) Huesler-Reiss log-likelihood, AIC, and BIC values.
}
\seealso{
Other parameter estimation methods:
\code{\link{data2mpareto}()},
\code{\link{emp_chi_multdim}()},
\code{\link{emp_chi}()},
\code{\link{emp_vario}()},
\code{\link{emtp2}()},
\code{\link{fmpareto_HR_MLE}()},
\code{\link{fmpareto_graph_HR}()}
}
\concept{parameterEstimation}
