% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overhaul.R
\name{gt_edges}
\alias{gt_edges}
\alias{gt_edges_}
\title{Edges}
\usage{
gt_edges(data, tweets, source, id, ...)

gt_edges_(data, tweets = "text", source = "screen_name", id = "status_id",
  ...)
}
\arguments{
\item{data}{Data.frame of tweets, usually returned by the \code{rtweet} package.}

\item{tweets}{Column containing tweets.}

\item{source}{Author of tweets.}

\item{id}{tweets unique id.}

\item{...}{any other column name, see examples.}
}
\value{
An object of class \code{graphTweets}.
}
\description{
Get edges from data.frame of tweets.
}
\examples{
# simulate dataset
tweets <- data.frame(
  text = c("I tweet @you about @him", 
           "I tweet @me about @you"),
  screen_name = c("me", "him"),
  retweet_count = c(19, 5),
  status_id = c(1, 2),
  stringsAsFactors = FALSE
)

tweets \%>\% 
  gt_edges(text, screen_name, status_id)
  
tweets \%>\% 
  gt_edges_(RT = "retweet_count") # metadata
  
}
