% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_to_genind.R
\name{loci_to_genind}
\alias{loci_to_genind}
\title{Convert a loci object into a genind object}
\usage{
loci_to_genind(x, ploidy = 2, na.alleles = c("NA"))
}
\arguments{
\item{x}{An object of class \code{loci} to convert}

\item{ploidy}{An integer indicating the ploidy level
(by default, 'ploidy = 2')}

\item{na.alleles}{A character vector indicating the coding of the alleles
to be treated as missing data (by default, 'na.alleles = c("NA")')}
}
\value{
An object of class \code{genind}
}
\description{
This function is exactly the same as \code{loci2genind}
from \pkg{pegas} package
}
\examples{
data("data_pc_loci")
genind <- loci_to_genind(data_pc_loci, ploidy = 2, na.alleles = "NA")
}
\author{
P. Savary
}
