% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genind_to_genepop.R
\name{genind_to_genepop}
\alias{genind_to_genepop}
\title{Convert a genind object into a GENEPOP file}
\usage{
genind_to_genepop(x, output = "data.frame")
}
\arguments{
\item{x}{An object of class \code{genind}
from package \pkg{adegenet}.}

\item{output}{A character string indicating the option used to select what
the function will return:
\itemize{
\item{If \code{output = "data.frame"}(default), then the function will
return an object 'x' of class \code{data.frame} ready to be saved as a
text file with the following command:
\code{write.table(x, file = "file_name.txt", quote=FALSE,
row.names=FALSE, col.names=FALSE)}}
\item{If \code{output = "path_to_file/file_name.txt"}, then the function
will write a text file named 'file_name.txt' in the directory corresponding
to 'path_to_file'. Without 'path_to_file', the text file is written in the
current working directory. The text file has the format required by GENEPOP
software.}
}}
}
\value{
An object of type \code{data.frame} if \code{ouput = "data.frame"}.
If \code{output} is the path and/or the file name of a text file, then
nothing is returned in R environment but a text file is created with the
specified file name, either in the current working directory or in the
specified folder.
}
\description{
The function converts an object of class \code{genind} into
a GENEPOP file.
It then allows to use the functionalities of the GENEPOP software and
its derived package \pkg{GENEPOP} on R, as well as some functions
from other packages (differentiation test, F-stats calculations,
HWE test,...).
It is designed to be used with diploid microsatellite data and
alleles coded with 3 digits
}
\section{Warning}{

\subsection{Confusion}{
Do not confound this function with \code{\link[adegenet]{genind2genpop}}
from \pkg{adegenet}. The latter converts an object of class \code{genind}
into an object of class \code{genpop}, whereas \code{genind_to_genepop}
converts an object of class \code{genind} into a text file compatible with
GENEPOP software (Rousset, 2008).
}
\subsection{Allele coding}{
This function can handle genetic data with different alleles coding lengths
(for example alleles '99' and '101' at one locus).
BUT, it is highly advisable not to use it with this type
of data because applications using GENEPOP file won't be able to use the
output file.
}
\subsection{Individuals order}{
When individuals in input data are not ordered by populations, individuals
from the same population can be separated by individuals from other
populations. It can be problematic when calculating then pairwise distance
matrices. Therefore, in such a case, individuals are ordered by populations
and populations ordered in alphabetic order.
}
}

\examples{
data(data_pc_genind)
x <- data_pc_genind
df_genepop <- suppressWarnings(genind_to_genepop(x,
                                                 output = "data.frame"))
}
\references{
\insertRef{raymond1995genepop}{graph4lg}
}
\seealso{
For more details about GENEPOP file formatting :
\url{http://genepop.curtin.edu.au/help_input.html#Input}.
For the opposite conversion, see \code{\link{genepop_to_genind}}.
The output file can be used to compute pairwise FST matrix
with \code{\link{mat_pw_fst}}
}
\author{
P. Savary
}
