% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_topo_compar.R
\name{graph_topo_compar}
\alias{graph_topo_compar}
\title{Compute an index comparing graphs' topologies}
\usage{
graph_topo_compar(obs_graph, pred_graph, mode = "mcc",
  directed = FALSE)
}
\arguments{
\item{obs_graph}{A graph object of class \code{igraph} with n nodes.
It is the observed graph that \code{pred_graph} is supposed to approach.}

\item{pred_graph}{A graph object of class \code{igraph} with n nodes.
It is the predicted graph that is supposed to be akin to \code{obs_graph}.}

\item{mode}{A character string specifying which index to compute in order
to compare the topologies of the graphs.
\itemize{
\item{If 'mode = 'mcc'' (default), the Matthews Correlation Coefficient (MCC) is computed.}
\item{If 'mode = 'kappa'', the Kappa index is computed.}
\item{If 'mode = 'fdr'', the False Discovery Rate (FDR) is computed.}
\item{If 'mode = 'acc'', the Accuracy is computed.}
\item{If 'mode = 'sens'', the Sensitivity is computed.}
\item{If 'mode = 'spec'', the Specificity is computed.}
\item{If 'mode = 'prec'', the Precision is computed.}
}}

\item{directed}{Logical (TRUE or FALSE) specifying whether both graphs
are directed or not.}
}
\value{
The value of the index computed
}
\description{
The function computes several indices in order to compare two
graphs' topologies. One of the graph has the "true" topology the other is
supposed to reproduce. The indices are then a way to assess the reliability
of the latter graph.
Both graphs must have the same number of nodes, but not necessarily the
same number of links. They must also have the same nodes' names and in
the same order.
}
\details{
The indices are calculated from a confusion matrix counting the number
of links that are in the "observed" graph ("true") and also in the "predicted"
graph (true positives : TP), that are in the "observed" graph but not in the
"predicted" graph (false negatives : FN), that are not in the "observed"
graph but in the "predicted" graph (false positives : FP) and that are not
in the "observed" graph and not in the "predicted" graph neither (true
negatives: TN). K is the total number of links in the graphs.
K is equal to \eqn{n\times(n-1)} if the graphs are directed and to
\eqn{\frac{n\times(n-1)}{2}} if they are not directed, with n the number of nodes.
OP = TP + FN, ON = TN + FP, PP = TP + FP and PN = FN + TN.

The Matthews Correlation Coefficient (MCC) is computed as follows:
\eqn{MCC = \frac{TP\times TN-FP\times FN}{\sqrt{(TP+FP)(TP+FN)(TN+FP)(TN+FN)}}}

The Kappa index is computed as follows:
\eqn{Kappa = \frac{K\times (TP + TN) - (ON \times PN) - (OP \times PP)}{K^{2} - (ON \times PN) - (OP \times PP)}}

The False Discovery Rate (FDR) is calculated as follows:
\eqn{FDR = \frac{FP}{TP+FP}}

The Accuracy is calculated as follows:
\eqn{Acc = \frac{TP + TN}{K}}

The Sensitivity is calculated as follows:
\eqn{Sens = \frac{TP}{TP+FN}}

The Specificity is calculated as follows:
\eqn{Spec = \frac{TN}{TN+FP}}

The Precision is calculated as follows:
\eqn{Prec = \frac{TP}{TP+FP}}

Self loops are not taken into account.
}
\examples{
data(data_simul_genind)
data(pts_pop_simul)
mat_dist <- suppressWarnings(graph4lg::mat_geo_dist(data=pts_pop_simul,
      ID = "ID",
      x = "x",
      y = "y"))
mat_dist <- mat_dist[order(as.character(row.names(mat_dist))),
                      order(as.character(colnames(mat_dist)))]
graph_obs <- gen_graph_thr(mat_w = mat_dist, mat_thr = mat_dist,
                            thr = 15000, mode = "larger")
mat_gen <- mat_gen_dist(x = data_simul_genind, dist = "DPS")
graph_pred <- gen_graph_topo(mat_w = mat_gen, mat_topo = mat_dist,
                            topo = "gabriel")
graph_topo_compar(obs_graph = graph_obs,
                  pred_graph = graph_pred,
                  mode = "mcc",
                  directed = FALSE)
}
\references{
\insertRef{dyer2004population}{graph4lg}
\insertRef{baldi2000assessing}{graph4lg}
\insertRef{matthews1975comparison}{graph4lg}
}
\author{
P. Savary
}
