% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_torus.R
\name{create_torus}
\alias{create_torus}
\title{Pad a raster by a specified radius}
\usage{
create_torus(dat, dpad)
}
\arguments{
\item{dat}{The raster dataset to pad}

\item{dpad}{The amount by which to pad the raster (in the same units as the
raster)}
}
\value{
raster. Original raster padded by r cells with torus effect (see
  Details)
}
\description{
This function pads a raster by a specified number of cells, creating the
effect of a torus. This function is intended for use on simulated landscapes,
in order to avoid edge effects
}
\details{
A torus is an infinite surface where the top joins the bottom, and
  the left side meets the right side. See https://en.wikipedia.org/wiki/Torus
  for a full mathematical description.

  In this function, the torus effect is achieved by adding the specified
  number of rows of the top of the raster to the bottom (and vice versa) and
  the specified number of rows of the right of the raster to the left (and
  vice versa)
}
\examples{
data(cat_ls)
d <- create_torus(dat = cat_ls, dpad = 5)
}
\keyword{raster}
\keyword{torus}
