#' List of palettes available in grafify package
#' 
#' To visualise these colours use \code{plot_grafify_palette}.
#' @return This function returns a list of palettes in grafify with names and hexcodes of colours in those  palettes.
#' Names of palettes available are as follows:
#' 
#' Categorical/discreet palettes: 
#' - `okabe_ito`
#' - `bright`
#' - `contrast`
#' - `dark`
#' - `kelly`
#' - `light`
#' - `muted`
#' - `pale`
#' - `r4`
#' - `safe`
#' - `vibrant`
#' 
#' Sequential quantitative palettes:
#' - `grey_conti`
#' - `blue_conti`
#' - `yellow_conti`
#' 
#' Divergent quantitative palettes:
#' - `OrBl_div`
#' - `PrGn_div`
#'  
#' @export
#' 
graf_palettes <- list(
  'okabe_ito' = get_graf_colours("ok_orange",
                                 "ok_skyblue",
                                 "ok_bluegreen",
                                 "ok_yellow",
                                 "ok_blue",
                                 "ok_vermillion",
                                 "ok_redpurple",
                                 "ok_grey",
                                 "contrast_black"),
  'bright' = get_graf_colours( "bright_red",
                               "bright_blue",
                               "bright_yellow",
                               "bright_green",
                               "bright_cyan",
                               "bright_purple",
                               "bright_grey"),
  'contrast' = get_graf_colours("contrast_black",
                                "contrast_white",
                                "contrast_yellow",
                                "contrast_red",
                                "contrast_blue"),
  'dark' = get_graf_colours("dark_blue",
                            "dark_cyan",
                            "dark_yellow",
                            "dark_green",
                            "dark_red",
                            "dark_grey"),
  'fishy' = get_graf_colours("fishy_1", 
                             "fishy_2",
                             "fishy_3", 
                             "fishy_4",
                             "fishy_5", 
                             "fishy_6",
                             "fishy_7", 
                             "fishy_8",
                             "fishy_9"),
  'kelly' = get_graf_colours("kelly_1",
                             "kelly_2" ,
                             "kelly_3",
                             "kelly_4" ,
                             "kelly_5",
                             "kelly_6" ,
                             "kelly_7",
                             "kelly_8" ,
                             "kelly_9",
                             "kelly_10",
                             "kelly_11",
                             "kelly_12",
                             "kelly_13",
                             "kelly_14",
                             "kelly_15",
                             "kelly_16",
                             "kelly_17",
                             "kelly_18",
                             "kelly_19",
                             "kelly_20"),
  'light' = get_graf_colours("light_orange",
                             "light_blue",
                             "light_yellow",
                             "light_pink",
                             "light_cyan",
                             "light_mint",
                             "light_pear",
                             "light_olive",
                             "pale_grey"),
  'muted' = get_graf_colours("muted_rose",
                             "muted_indigo",
                             "muted_sand",
                             "muted_green",
                             "muted_cyan",
                             "muted_wine",
                             "muted_teal",
                             "muted_olive",
                             "muted_purple",
                             "pale_grey"),
  'pale' = get_graf_colours( "pale_blue",
                             "pale_cyan",
                             "pale_green",
                             "pale_yellow",
                             "pale_red",
                             "pale_grey"),
  'r4' = get_graf_colours("r4_1",
                          "r4_2",
                          "r4_3",
                          "r4_4",
                          "r4_5",
                          "r4_6"),
  'safe' = get_graf_colours("safe_blue" ,
                            "safe_red",
                            "safe_yellow" ,
                            "safe_green",
                            "safe_violet" ,
                            "safe_purple" ,
                            "safe_bluegreen",
                            "safe_bush",
                            "safe_reddish",
                            "safe_wine", 
                            "safe_skyblue"),
  'vibrant' = get_graf_colours("vibrant_orange",
                               "vibrant_blue",
                               "vibrant_magenta",
                               "vibrant_cyan",
                               "vibrant_red",
                               "vibrant_teal",
                               "bright_grey"),
  'OrBl_div' = get_graf_colours("OrBl_1", 
                                "OrBl_2", 
                                "OrBl_3", 
                                "OrBl_4", 
                                "OrBl_5", 
                                "OrBl_6", 
                                "OrBl_7", 
                                "OrBl_8", 
                                "OrBl_9", 
                                "OrBl_10",
                                "OrBl_11"),
  'PrGn_div' = get_graf_colours("PrGn_1",
                                "PrGn_2",
                                "PrGn_3",
                                "PrGn_4",
                                "PrGn_5",
                                "PrGn_6",
                                "PrGn_7",
                                "PrGn_8",
                                "PrGn_9",
                                "PrGn_10",
                                "PrGn_11"),
  'blue_conti' = get_graf_colours("blue_1",
                                  "blue_2",
                                  "blue_3",
                                  "blue_4",
                                  "blue_5",
                                  "blue_6",
                                  "blue_7",
                                  "blue_8",
                                  "blue_9",
                                  "blue_10",
                                  "blue_11"),
  'grey_conti' = get_graf_colours("grey_lin1",
                                  "grey_lin2",
                                  "grey_lin3",
                                  "grey_lin4",
                                  "grey_lin5",
                                  "grey_lin6",
                                  "grey_lin7",
                                  "grey_lin8",
                                  "grey_lin9",
                                  "grey_lin10",
                                  "grey_lin11"),
  'yellow_conti' = get_graf_colours("YlOrBr_1", 
                                    "YlOrBr_2",
                                    "YlOrBr_3",
                                    "YlOrBr_4",
                                    "YlOrBr_5",
                                    "YlOrBr_6",
                                    "YlOrBr_7",
                                    "YlOrBr_8",
                                    "YlOrBr_9"),
  'all_grafify' = get_graf_colours("ok_orange",
                                   "ok_skyblue",
                                   "ok_bluegreen",
                                   "ok_yellow",
                                   "ok_blue",
                                   "ok_vermillion",
                                   "ok_redpurple",
                                   "muted_indigo",
                                   "muted_cyan",
                                   "muted_teal",
                                   "muted_green",
                                   "muted_olive",
                                   "muted_sand",
                                   "muted_rose",
                                   "muted_wine",
                                   "muted_purple",
                                   "light_blue",
                                   "light_cyan",
                                   "light_mint",
                                   "light_pear",
                                   "light_olive",
                                   "light_yellow",
                                   "light_orange",
                                   "light_pink",
                                   "pale_blue",
                                   "pale_cyan",
                                   "pale_green",
                                   "pale_yellow",
                                   "pale_red",
                                   "pale_grey",
                                   "dark_grey",
                                   "bright_grey",
                                   "ok_grey",
                                   "contrast_white",
                                   "contrast_yellow",
                                   "contrast_red",
                                   "contrast_blue",
                                   "contrast_black",
                                   "vibrant_blue",
                                   "vibrant_cyan",
                                   "vibrant_teal",
                                   "vibrant_orange",
                                   "vibrant_red",
                                   "vibrant_magenta",
                                   "dark_blue",
                                   "dark_cyan",
                                   "dark_green",
                                   "dark_yellow",
                                   "dark_red",
                                   "bright_blue",
                                   "bright_cyan",
                                   "bright_green",
                                   "bright_yellow",
                                   "bright_red",
                                   "bright_purple")
#   'zesty' = get_graf_colours("zesty_orange",
#                              "zesty_purple",
#                              "zesty_skyblue",
#                              "zesty_blue"),
#   'pastel' = get_graf_colours("pastel_brown",
#                               "pastel_cream",
#                               "pastel_skyblue",
#                               "pastel_blue"),
#   'elegant' = get_graf_colours("elegant_green",
#                                "elegant_cream",
#                                "elegant_bush",
#                                "elegant_brown"),
#   'milly' = get_graf_colours("milly_1",  
#                              "milly_2" ,
#                              "milly_3",  
#                              "milly_4" ,
#                              "milly_5",  
#                              "milly_6" ,
#                              "milly_7",  
#                              "milly_8" ,
#                              "milly_9",  
#                              "milly_10"),
#   'rainbow' = get_graf_colours("rainbow_1",
#                                "rainbow_2", 
#                                "rainbow_3", 
#                                "rainbow_4" ,
#                                "rainbow_5", 
#                                "rainbow_6" ,
#                                "rainbow_7", 
#                                "rainbow_8" ,
#                                "rainbow_9", 
#                                "rainbow_10",
#                                "rainbow_11",
#                                "rainbow_12",
#                                "rainbow_13",
#                                "rainbow_14",
#                                "rainbow_15",
#                                "rainbow_16",
#                                "rainbow_17",
#                                "rainbow_18",
#                                "rainbow_19",
#                                "rainbow_20",
#                                "rainbow_21",
#                                "rainbow_22",
#                                "rainbow_23"),
#   'winter' = get_graf_colours("winter_1",
#                               "winter_2",
#                               "winter_3",
#                               "winter_4",
#                               "winter_5",
#                               "winter_6",
#                               "winter_7",
#                               "winter_8",
#                               "winter_9"),
)
