% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_3d_scatterviolin.R
\name{plot_3d_scatterviolin}
\alias{plot_3d_scatterviolin}
\title{Plot a scatter with violin & box plot for 1-way ANOVAs with matched shapes mapped to blocking factor.}
\usage{
plot_3d_scatterviolin(
  data,
  xcol,
  ycol,
  shapes,
  facet,
  symsize = 3,
  s_alpha = 0.8,
  b_alpha = 0,
  v_alpha = 1,
  bwid = 0.3,
  vadjust = 1,
  jitter = 0.1,
  TextXAngle = 0,
  scale = "width",
  trim = TRUE,
  LogYTrans,
  LogYBreaks = waiver(),
  LogYLabels = waiver(),
  LogYLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  symthick,
  bthick,
  vthick,
  bvthick,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  ...
)
}
\arguments{
\item{data}{a data table, e.g. data.frame or tibble.}

\item{xcol}{name of the column with the categorical factor to be plotted on X axis. If your table has numeric X, enter \code{xcol = factor(name of colum)}.}

\item{ycol}{name of the column with quantitative variable to plot on the Y axis.}

\item{shapes}{name of the column with the second categorical factor in a two-way ANOVA design.}

\item{facet}{add another variable from the data table to create faceted graphs using \code{ggplot2}\link{facet_wrap}.}

\item{symsize}{size of symbols, default set to 3.}

\item{s_alpha}{fractional opacity of symbols, default set to 0.8 (i.e. 80\% opacity). Set \code{s_alpha = 0} to not show scatter plot.}

\item{b_alpha}{fractional opacity of boxes.  Default is set to 0, which results in white boxes inside violins. Change to any value >0 up to 1 for different levels of transparency.}

\item{v_alpha}{fractional opacity of violins, default set to 1.}

\item{bwid}{width of boxes (default 0.3).}

\item{vadjust}{number to adjust the smooth/wigglyness of violin plot (default is 1).}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0.1. Increase to reduce symbol overlap, set to 0 for aligned symbols.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{scale}{set to "area" by default, can be changed to "count" or "width".}

\item{trim}{set whether tips of violin plot should be trimmed at high/low data. Default \code{trim = T}, can be changed to F.}

\item{LogYTrans}{transform Y axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{thickness (in 'pt' units) of boxplots; default = \code{fontsize}/22.}

\item{vthick}{thickness (in 'pt' units) of violins; default = \code{fontsize}/22.}

\item{bvthick}{thickness (in 'pt' units) of both violins and boxplots; default = \code{fontsize}/22.}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} or base R palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot} or \code{ggplot2}\link{geom_violin}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
One of 4 related functions for plotting 1-way ANOVA designs with a blocking factor.
\enumerate{
\item \code{\link{plot_3d_point_sd}} (mean & SD, SEM or CI95 error bars)
\item \code{\link{plot_3d_scatterbar}} (bar & SD, SEM or CI95 error bars)
\item \code{\link{plot_3d_scatterbox}} (box & whiskers)
\item \code{\link{plot_3d_scatterviolin}} (box & whiskers, violin)
}
}
\details{
The blocking factor (or any other categorical variable) can be mapped to the \code{shapes} argument (up to 25 levels allowed). Variables passed to \code{xcol} and \code{shapes} are internally converted to factors even if they are numeric or other type of variables.

In \code{plot_3d_point_sd} and \code{plot_3d_scatterbar}, the default error bar is SD (can be changed to SEM or CI95). In \code{plot_3d_point_sd}, a large coloured symbol is plotted at the mean, all other data are shown as smaller symbols. Boxplot uses \code{\link[ggplot2]{geom_boxplot}} to depict median (thicker line), box (interquartile range (IQR)) and the whiskers (1.5*IQR).

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

The resulting \code{ggplot2} graph can take additional geometries or other layers.
}
\examples{
#3d version for 1-way data with blocking
plot_3d_scatterviolin(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
shapes = Experiment)
#use plot_scatterviolin without a blocking factor

}
