% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_3d_scatterbar.R
\name{plot_3d_scatterbar}
\alias{plot_3d_scatterbar}
\title{Plot a scatter graph with matched shapes on a bar plot using three variables.}
\usage{
plot_3d_scatterbar(
  data,
  xcol,
  ycol,
  shapes,
  facet,
  ErrorType = "SD",
  symsize = 3,
  s_alpha = 0.8,
  b_alpha = 1,
  jitter = 0.1,
  ewid = 0.2,
  TextXAngle = 0,
  LogYTrans,
  LogYBreaks = waiver(),
  LogYLabels = waiver(),
  LogYLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  symthick,
  bthick,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  ...
)
}
\arguments{
\item{data}{a data table, e.g. data.frame or tibble.}

\item{xcol}{name of the column with the categorical factor to be plotted on X axis.}

\item{ycol}{name of the column with quantitative variable to plot on the Y axis.}

\item{shapes}{name of the column with the second categorical factor, for example from a two-way ANOVA design.}

\item{facet}{add another variable from the data table to create faceted graphs using \code{ggplot2}\link{facet_wrap}.}

\item{ErrorType}{select the type of error bars to display. Default is "SD" (standard deviation). Other options are "SEM" (standard error of the mean) and "CI95" (95\% confidence interval based on t distributions).}

\item{symsize}{size of symbols, default set to 3.}

\item{s_alpha}{fractional opacity of symbols, default set to 0.8 (i.e. 80\% opacity). Set \code{s_alpha = 0} to not show scatter plot.}

\item{b_alpha}{fractional opacity of boxes.  Default is set to 0, which results in white boxes inside violins. Change to any value >0 up to 1 for different levels of transparency.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0.1. Increase to reduce symbol overlap, set to 0 for aligned symbols.}

\item{ewid}{width of error bars, default set to 0.2.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{LogYTrans}{transform Y axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{thickness (in 'pt' units) of lines of boxes; default = \code{fontsize}/22.}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} palettes or base R to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{...}{any additional arguments to pass.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
The functions \code{\link{plot_3d_scatterbar}}, \code{\link{plot_3d_scatterbox}}, \code{\link{plot_4d_scatterbar}}  and \code{\link{plot_4d_scatterbox}} are useful for plotting one-way or two-way ANOVA designs with randomised blocks or repeated measures. The blocks or subjects can be mapped to the \code{shapes} argument in both functions (up to 25 levels can be mapped to \code{shapes}; there will be an error if this number is exceeded). The 3d versions use the categorical variable (\code{xcol}) for grouping (e.g. one-way ANOVA designs), and 4d versions take an additional grouping variable (e.g. two-way ANOVA designs) that is passed to either \code{boxes} or \code{bars} argument.
}
\details{
These functions rely on \code{\link[ggplot2]{ggplot}} with \code{\link[ggplot2]{geom_point}} and \code{\link[ggplot2]{geom_bar}} (through \code{stat_summary}) or \code{\link[ggplot2]{geom_boxplot}} geometries.

Variables other than the quantitative variable (\code{ycol}) will be automatically converted to categorical variables even if they are numeric in the data table.

Shapes are always plotted in black colour, and their opacity can be changed with the \code{s_alpha} argument and overlap can be reduced with the \code{jitter} argument. Other arguments are similar to other plot functions as briefly explained below.

Bars depict means using \code{\link[ggplot2]{stat_summary}} with \code{geom = "bar", fun = "mean"} , and bar width is set to 0.7 (cannot be changed). Error bar width can be changed with the \code{ewid} argument.

Boxplot geometry uses \code{\link[ggplot2]{geom_boxplot}} with \code{position = position_dodge(width = 0.9), width = 0.6}. The thick line within the boxplot depicts the median, the box the IQR (interquartile range) and the whiskers show 1.5*IQR.

In 4d versions, the two grouping variables (i.e. \code{xcol} and either \code{boxes} or \code{bars}) are passed to ggplot aesthetics through \code{group = interaction{ xcol, shapes}}.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

All four functions can be expanded further, for example with \code{\link[ggplot2]{facet_grid}} or \code{\link[ggplot2]{facet_wrap}}.
}
\examples{
#3d version for 1-way data with blocking
plot_3d_scatterbar(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
shapes = Experiment)
#compare above graph to
plot_scatterbar_sd(data = data_1w_death, 
xcol = Genotype, ycol = Death)
#single colour
plot_3d_scatterbar(data = data_1w_death, 
xcol = Genotype, ycol = Death,
shapes = Experiment,
SingleColour = "pale_grey")

#4d version for 2-way data with blocking
plot_4d_scatterbox(data = data_2w_Tdeath, 
xcol = Genotype, 
ycol = PI, 
boxes = Time, 
shapes = Experiment)

plot_4d_scatterbar(data = data_2w_Festing, 
xcol = Strain, 
ycol = GST, 
bars = Treatment, 
shapes = Block)

}
