% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc_Trends.R
\name{posthoc_Trends}
\alias{posthoc_Trends}
\title{Use emtrends to get slopes for an independent quantitative variable from a linear model.}
\usage{
posthoc_Trends(Model, Fixed_Factor, Trend_Factor, P_Adj = "sidak", ...)
}
\arguments{
\item{Model}{a model object fit using \code{\link{simple_model}} or \code{\link{mixed_model}} (or \code{\link{lm}} or \code{\link[lmerTest]{lmer}}).}

\item{Fixed_Factor}{one or  more categorical variables, provided as a vector (see Examples), whose levels you wish to compare pairwise. Names of Fixed_Factor should match Fixed_Factor used to fit the model. When more than one factor is provided e.g. \code{Fixed_factor = c("A", "B")}, this function passes this on as \code{specs = A:B} (note the colon between the two Fixed_Factor) to \code{\link[emmeans]{emmeans}} to produce pairwise comparisons.}

\item{Trend_Factor}{a quantitative variable that interacts with a factor and whose slope (trend) is to be compared}

\item{P_Adj}{method for correcting P values for multiple comparisons. Default is "sidak", can be changed to "bonferroni". See Interaction analysis in emmeans in the \href{https://CRAN.R-project.org/package=emmeans}{manual} for \code{emmeans}.}

\item{...}{additional arguments for \code{\link[emmeans]{emmeans}} such as \code{lmer.df} or others. See help for sophisticated models in \href{https://CRAN.R-project.org/package=emmeans}{emmeans}.}
}
\value{
returns an "emm_list" object containing contrasts and emmeans through  \code{\link[emmeans]{emmeans}}.
}
\description{
This function is a wrapper based on \code{\link[emmeans]{emmeans}}, and needs a ordinary linear model produced by \code{\link{simple_model}} or a mixed effects model produced by \code{\link{mixed_model}} or \code{\link{mixed_model_slopes}} (or generated directly with \code{lm},  \code{lme4} or \code{lmerTest} calls). At least one of the factors should be a numeric covariate whose slopes you wish to find. It also needs to know the fixed factor(s), which should match those in the model and data table.
}
\details{
Checkout the Interactions with covariates section in the \href{https://CRAN.R-project.org/package=emmeans}{emmeans} vignette for more details. One of the independent variables should  be a quantitative (e.g. time points) variable whose slope (trend) you want to find at levels of the other factor.
}
\examples{
#create an lm model 
#Time2 is numeric (time points)
m1 <- simple_model(data = data_2w_Tdeath, 
Y_value = "PI", Fixed_Factor = c("Genotype", "Time2"))
posthoc_Trends(Model = m1, 
Fixed_Factor = "Genotype", 
Trend_Factor = "Time2")

}
