% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qqmodel.R
\name{plot_qqmodel}
\alias{plot_qqmodel}
\title{Plot quantile-quantile (QQ) graphs from residuals of linear models.}
\usage{
plot_qqmodel(Model)
}
\arguments{
\item{Model}{name of a saved model generated by \code{simple_model} or \code{mixed_model}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a linear model (simple or mixed effects) and plots a QQ graph after running \code{augment} from \code{\link[broom.mixed]{augment}} to generate a table of model residuals on a saved ordinary (\code{\link{simple_model}}) or mixed model (\code{\link{mixed_model}} or \code{\link{mixed_model_slopes}}. The graph plots residuals from the model (sample) on Y axis & theoretical quantiles on X axis.
}
\details{
The function uses \code{plot_qqline}, which relies on \code{stat_qq} and \code{stat_qq_line} geometries (get help with \code{?stat_qq_line}).
}
\examples{
#Basic usage
m1 <- simple_model(data = data_2w_Festing, 
Y_value = "GST", 
Fixed_Factor = c("Treatment", "Strain"))
plot_qqmodel(m1)

}
