% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StreamHandler.R
\name{StreamHandler}
\alias{StreamHandler}
\title{Stream handler for chat completions}
\description{
Stream handler for chat completions

Stream handler for chat completions
}
\details{
R6 class that allows to handle chat completions chunk by chunk.
It also adds methods to retrieve relevant data. This class DOES NOT make the request.

Because \code{curl::curl_fetch_stream} blocks the R console until the stream finishes,
this class can take a shiny session object to handle communication with JS
without recurring to a \code{shiny::observe} inside a module server.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{current_value}}{The content of the stream. It updates constantly until the stream ends.}

\item{\code{chunks}}{The list of chunks streamed. It updates constantly until the stream ends.}

\item{\code{shinySession}}{Holds the \code{session} provided at initialization}

\item{\code{user_message}}{The \code{user_prompt} provided at initialization after being formatted with markdown.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StreamHandler-new}{\code{StreamHandler$new()}}
\item \href{#method-StreamHandler-handle_streamed_element}{\code{StreamHandler$handle_streamed_element()}}
\item \href{#method-StreamHandler-extract_message}{\code{StreamHandler$extract_message()}}
\item \href{#method-StreamHandler-clone}{\code{StreamHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-new}{}}}
\subsection{Method \code{new()}}{
Start a StreamHandler. Recommended to be assigned to the \code{stream_handler} name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$new(session = NULL, user_prompt = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{The shiny session it will send the message to (optional).}

\item{\code{user_prompt}}{The prompt for the chat completion. Only to be displayed in an HTML tag containing the prompt. (Optional).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-handle_streamed_element"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-handle_streamed_element}{}}}
\subsection{Method \code{handle_streamed_element()}}{
The main reason this class exists. It reduces to stream to chunks and its current value. If the object finds a shiny session will send a \code{render-stream} message to JS.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$handle_streamed_element(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The streamed element. Preferably after conversion from raw.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-extract_message"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-extract_message}{}}}
\subsection{Method \code{extract_message()}}{
Extract the message content as a message ready to be styled or appended to the chat history. Useful after the stream ends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$extract_message()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StreamHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
