% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gsnpense}
\alias{gsnpense}
\title{Convert SNP rs numbers to genes.}
\usage{
gsnpense(query, filter_na = TRUE)
}
\arguments{
\item{query}{vector of SNP IDs to be translated (should start with prefix 'rs').}

\item{filter_na}{logical indicating whether to filter out results without a
corresponding target name.}
}
\value{
The output is a data.frame which is a table closely corresponding to the
web interface output. Columns 'ensgs' and 'gene_names' can contain list of multiple values.
}
\description{
Interface to the g:Profiler tool g:SNPense (\url{https://biit.cs.ut.ee/gprofiler/snpense}) that maps SNP rs identifiers to chromosome positions, genes and variant effects.
Available only for human SNPs.
}
\examples{
gsnpense(c("rs11734132", "rs7961894", "rs4305276", "rs17396340", "rs3184504"))
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>, Uku Raudvere <uku.raudvere@ut.ee>
}
