% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/versions.R
\name{gtm_versions_delete}
\alias{gtm_versions_delete}
\title{Delete a container version}
\usage{
gtm_versions_delete(
  account_id,
  container_id,
  version_id,
  force = c("TRUE", "FALSE")
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{version_id}{Version Id}

\item{force}{Force deletion without user input}
}
\description{
Deletes a container version
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
versionId <- 6

gtm_versions_delete(accountId, containerId, versionId)

# This will delete Version \%s. Are you sure you want to continue?

#  1: Yes
#  2: No

# Selection: 1

# Version 6 has been deleted.

tagId = 7

gtm_versions_delete(accountId, containerId, versionId, "TRUE")

# Version 7 has been deleted.

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/versions/delete}

Other version functions: 
\code{\link{gtm_versions_get}()},
\code{\link{gtm_versions_update}()}
}
\concept{version functions}
