% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{topics_create}
\alias{topics_create}
\title{Creates a pub/sub topic}
\usage{
topics_create(
  name,
  labels = NULL,
  kms_key_name = NULL,
  satisfies_pzs = NULL,
  message_storage_policy = NULL,
  schema_settings = NULL,
  message_retention_duration = NULL
)
}
\arguments{
\item{name}{\code{character}, \code{Topic} Required, topic name or instance of a topic object}

\item{labels}{\code{list} Key-value pairs for topic labels}

\item{kms_key_name}{\code{character} The resource name of the Cloud KMS CryptoKey to be used
to protect access to messages published on this topic.}

\item{satisfies_pzs}{\code{logical} Reserved for future use.}

\item{message_storage_policy}{\code{MessageStorePolicy} An instance of a \code{MessageStorePolicy} object
Policy constraining the set of Google Cloud Platform regions where messages published to the
topic may be stored}

\item{schema_settings}{\code{SchemaSettings} An instance of a \code{SchemaSettings} object}

\item{message_retention_duration}{\code{numeric} Indicates the minimum duration (in seconds) to retain
a message after it is published to the topic}
}
\value{
A \code{Topic} object representing the freshly created topic
}
\description{
Creates a pub/sub topic
}
\seealso{
Other Topic functions: 
\code{\link{topics_delete}()},
\code{\link{topics_exists}()},
\code{\link{topics_get}()},
\code{\link{topics_list_subscriptions}()},
\code{\link{topics_list}()},
\code{\link{topics_patch}()},
\code{\link{topics_publish}()}
}
\concept{Topic functions}
