% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcp.R
\name{gcp_submit}
\alias{gcp_submit}
\title{Submit print job to printer}
\usage{
gcp_submit(printerid, title, ticket = jsonlite::toJSON(list(version =
  jsonlite::unbox("1.0"), print = c()), auto_unbox = FALSE), content,
  contentType, tag = NULL)
}
\arguments{
\item{printerid}{The ID of the printer}

\item{title}{Title of print job}

\item{ticket}{Print ticket, see notes}

\item{content}{Document to print, see notes}

\item{contentType}{MIME type of document to print}

\item{tag}{Tags to add to print job}
}
\description{
Submit print job to printer
}
\note{
For info about parameters see \url{https://developers.google.com/cloud-print/docs/appInterfaces#submit}

If content is a path to a file it will use \code{httr::upload_file} otherwise it well send raw content
}
\examples{
\dontrun{
printer <- gcp_search("myPrinter")

gcp_submit(printer$id[1], 
           "New Title",
           content = 
             "<h1>Hello World</h1>",
           contentType = "text/html"
)
}

}
