% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubsub.R
\name{gcs_delete_pubsub}
\alias{gcs_delete_pubsub}
\title{Delete pub/sub notifications for a bucket}
\usage{
gcs_delete_pubsub(config_name, bucket = gcs_get_global_bucket())
}
\arguments{
\item{config_name}{The ID of the pubsub configuration}

\item{bucket}{The bucket for notifications}
}
\value{
TRUE if successful
}
\description{
Delete notification configurations for a bucket.
}
\details{
Cloud Pub/Sub notifications allow you to track changes to your Cloud Storage objects.
As a minimum you wil need: the Cloud Pub/Sub API activated for the project;
sufficient permissions on the bucket you wish to monitor;
sufficient permissions on the project to receive notifications;
an existing pub/sub topic; have given your service account at least \code{pubsub.publisher} permission.
}
\seealso{
\url{https://cloud.google.com/storage/docs/reporting-changes}

Other pubsub functions: \code{\link{gcs_create_pubsub}},
  \code{\link{gcs_get_service_email}},
  \code{\link{gcs_list_pubsub}}
}
\concept{pubsub functions}
