% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsession.R
\name{gcs_save_image}
\alias{gcs_save_image}
\title{Save an R session to the Google Cloud}
\usage{
gcs_save_image(file = ".RData", bucket = gcs_get_global_bucket(),
  saveLocation = NULL, envir = parent.frame())
}
\arguments{
\item{file}{Where to save the file in GCS and locally}

\item{bucket}{Bucket to store objects in}

\item{saveLocation}{Which folder in the bucket to save file}

\item{envir}{Environment to save from}
}
\value{
The GCS object
}
\description{
Performs \link{save.image} then saves it to Google Cloud Storage.
}
\details{
\code{gcs_save_image(bucket = "your_bucket")} will save all objects in the workspace
  to \code{.RData} folder on Google Cloud Storage within \code{your_bucket}.

Restore the objects using \code{gcs_load(bucket = "your_bucket")}

This will overwrite any data with the same name in your current local environment.
}
\seealso{
Other R session data functions: \code{\link{gcs_load}},
  \code{\link{gcs_save_all}}, \code{\link{gcs_save}},
  \code{\link{gcs_source}}
}
