% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber.R
\name{cr_plumber_pubsub}
\alias{cr_plumber_pubsub}
\title{Plumber - Pub/Sub parser}
\usage{
cr_plumber_pubsub(message = NULL, pass_f = function(x) x)
}
\arguments{
\item{message}{The pubsub message}

\item{pass_f}{An R function that will work with the data parsed out of the pubsub \code{message$data} field.}
}
\description{
A function to use in plumber scripts to accept Pub/Sub messages
}
\details{
This function is intended to be used within \link[plumber]{plumb} API scripts.  It needs to be annotated with a \code{@post} URL route and a \code{@param message The pubsub message} as per the plumber documentation.

\code{pass_f} should be a function you create that accepts one argument, the data from the pubsub \code{message$data} field.  It is unencoded for you.  Make sure the function returns a 200 response otherwise pub/sub will keep resending the message!  \code{return(TRUE)} is adequate.

The Docker container for the API will need to include \code{googleCloudRunner} installed in its R environment to run this function.  This is available in the public \code{gcr.io/gcer-public/cloudrunner} image.

Use \link{cr_pubsub} to test this function once deployed.
}
\examples{
\dontrun{

# within a plumber api.R script:

# example function echos back pubsub message
pub <- function(x) {
  paste("Echo:", x)
}

#' Recieve pub/sub message
#' @post /pubsub #nolint
#' @param message a pub/sub message
function(message = NULL) {
  googleCloudRunner::cr_plumber_pubsub(message, pub)
}
}
}
\seealso{
\href{https://cloud.google.com/run/docs/tutorials/pubsub}{Google Pub/Sub tutorial for Cloud Run}.  You can set up Pub/Sub messages from Google Cloud Storage buckets via \link[googleCloudStorageR]{gcs_create_pubsub}

Other Cloud Run functions: 
\code{\link{cr_jwt_create}()},
\code{\link{cr_run_email}()},
\code{\link{cr_run_get}()},
\code{\link{cr_run_list}()},
\code{\link{cr_run_schedule_http}()},
\code{\link{cr_run}()}
}
\concept{Cloud Run functions}
