% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudbuild_schedule.R
\name{cr_build_schedule_http}
\alias{cr_build_schedule_http}
\title{Create a Cloud Scheduler HTTP target from a Cloud Build object}
\usage{
cr_build_schedule_http(
  build,
  email = cr_email_get(),
  projectId = cr_project_get()
)
}
\arguments{
\item{build}{A \link{Build} object created via \link{cr_build_make} or \link{cr_build}}

\item{email}{The email that will authenticate the job set via \link{cr_email_set}}

\item{projectId}{The projectId}
}
\value{
A \link{HttpTarget} object for use in \link{cr_schedule}
}
\description{
This enables Cloud Scheduler to trigger Cloud Builds
}
\details{
Ensure you have a service email with \link{cr_email_set} of format \code{service-{project-number}@gcp-sa-cloudscheduler.iam.gserviceaccount.com} with Cloud Scheduler Service Agent role as per https://cloud.google.com/scheduler/docs/http-target-auth#add
}
\examples{
cloudbuild <- system.file("cloudbuild/cloudbuild.yaml", package = "googleCloudRunner")
build1 <- cr_build_make(cloudbuild)
build1

\dontrun{
cr_schedule("cloud-build-test1", schedule="15 5 * * *",
            httpTarget = cr_build_schedule_http(build1))

# a cloud build you would like to schedule
itworks <- cr_build("cloudbuild.yaml", launch_browser = FALSE)

# once working, pass in the build to the scheduler
cr_schedule("itworks-schedule", schedule = "15 5 * * *",
            httpTarget = cr_build_schedule_http(itworks))

}

}
\seealso{
https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds/create

Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{Job}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()},
\code{\link{cr_schedule_run}()},
\code{\link{cr_schedule}()}
}
\concept{Cloud Scheduler functions}
