% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_pkgdown}
\alias{cr_buildstep_pkgdown}
\title{Create buildsteps for deploying an R pkgdown website to GitHub}
\usage{
cr_buildstep_pkgdown(
  github_repo,
  git_email,
  secret,
  env = NULL,
  build_image = "gcr.io/gcer-public/packagetools:master",
  post_setup = NULL,
  post_clone = NULL
)
}
\arguments{
\item{github_repo}{The GitHub repo to deploy pkgdown website from and to.}

\item{git_email}{The email the git commands will be identifying as}

\item{secret}{The name of the secret on Google Secret Manager for the git ssh private key}

\item{env}{A character vector of env arguments to set for all steps}

\item{build_image}{A docker image with \code{pkgdown} installed}

\item{post_setup}{Steps that occur after git setup}

\item{post_clone}{A \link{cr_buildstep} that occurs after the repo is cloned}
}
\description{
Create buildsteps for deploying an R pkgdown website to GitHub
}
\details{
Its convenient to set some of the above via \link{Build} macros, such as \code{github_repo=$_GITHUB_REPO} and \code{git_email=$_BUILD_EMAIL} in the Build Trigger web UI

To commit the website to git, \link{cr_buildstep_gitsetup} is used for which
  you will need to add your git ssh private key to Google Secret Manager

The R package is installed via \link[devtools]{install} before
  running \link[pkgdown]{build_site}
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")

# set github repo directly to write it out via cr_build_write()
cr_buildstep_pkgdown("MarkEdmondson1234/googleCloudRunner",
                     git_email = "cloudbuild@google.com",
                     secret = "github-ssh")

# github repo set via build trigger macro _GITHUB_REPO
cr_buildstep_pkgdown("$_GITHUB_REPO",
                     git_email = "cloudbuild@google.com",
                     secret = "github-ssh")

# example including environment arguments for pkgdown build step
cr_buildstep_pkgdown("$_GITHUB_REPO",
                     git_email = "cloudbuild@google.com",
                     secret = "github-ssh",
                     env = c("MYVAR=$_MY_VAR", "PROJECT=$PROJECT_ID"))

}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
