% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_nginx_setup}
\alias{cr_buildstep_nginx_setup}
\title{Setup nginx for Cloud Run in a buildstep}
\usage{
cr_buildstep_nginx_setup(html_folder, ...)
}
\arguments{
\item{html_folder}{The folder that will hold the HTML for Cloud Run

This uses a premade bash script that sets up a Docker container ready for Cloud Run running nginx}

\item{...}{Other arguments passed to \link{cr_buildstep_bash}}
}
\description{
Setup nginx for Cloud Run in a buildstep
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
cr_region_set("europe-west1")

html_folder <- "my_html"
run_image <- "gcr.io/my-project/my-image-for-cloudrun"
cr_build_yaml(
 steps = c(
  cr_buildstep_nginx_setup(html_folder),
  cr_buildstep_docker(run_image, dir = html_folder),
  cr_buildstep_run(name = "running-nginx",
                   image = run_image,
                   concurrency = 80)
                   )
           )
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
