% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{StorageSource}
\alias{StorageSource}
\title{StorageSource Object}
\usage{
StorageSource(object, bucket = NULL, generation = NULL)
}
\arguments{
\item{object}{Google Cloud Storage object containing the source. This object must be a gzipped archive file (.tar.gz) containing source to build.}

\item{bucket}{Google Cloud Storage bucket containing the source}

\item{generation}{Google Cloud Storage generation for the object.  If the generation is omitted, the latest generation will be used.}
}
\value{
StorageSource object
}
\description{
StorageSource Object
}
\details{
Location of the source in an archive file in Google Cloud Storage.
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
# construct Source object
my_gcs_source <- Source(storageSource=StorageSource("my_code.tar.gz",
                                                    "gs://my-bucket"))
build1 <- cr_build("cloudbuild.yaml", source = my_gcs_source)

# helper that tars and adds to Source() for you
my_gcs_source2 <- cr_build_upload_gcs("my_folder")
build2 <- cr_build("cloudbuild.yaml", source = my_gcs_source2)

}
}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
