% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ga_model_make}
\alias{ga_model_make}
\title{Modelling function factory for Google Analytics data}
\usage{
ga_model_make(
  data_f,
  required_columns,
  model_f,
  output_f = function(df, ...) {
     plot(df)
 },
  required_packages = NULL,
  description = NULL,
  outputShiny = shiny::plotOutput,
  renderShiny = shiny::renderPlot,
  inputShiny = shiny::tagList()
)
}
\arguments{
\item{data_f}{A function that gets the data}

\item{required_columns}{What dimensions and metrics are required}

\item{model_f}{A function that inputs data, and outputs a list of assets -
must take data from result of \code{data_f} in first argument}

\item{output_f}{A function that inputs the output from \code{model_f}, outputs a visualisation}

\item{required_packages}{The packages needed for \code{data_f} and \code{model_f} to work}

\item{description}{An optional description of what the model does}

\item{outputShiny}{A shiny UI output function that will display the results \code{renderShiny}}

\item{renderShiny}{A shiny render function that will create the output for \code{outputShiny} from \code{output_f}}

\item{inputShiny}{Optional input shiny functions (like \code{dateInput()}) that will be used within the model's Shiny module.  The id should be exactly the same as one of the variables in the model functions.}
}
\value{
A \code{ga_model} object to pass to \link{ga_model}
}
\description{
Create ga_model objects for easy application of models to data
}
\details{
The passed functions should all have \code{...} to make them flexible
in what arguments can be added.  Do not have the same argument names in both functions.
The \code{data_f} function result will feed to \code{model_f}
}
\examples{

\dontrun{

 get_model_data <- function(viewId,
                           date_range = c(Sys.Date()- 300, Sys.Date()),
                           ...){
   google_analytics(viewId,
                    date_range = date_range,
                    metrics = "sessions",
                    dimensions = "date",
                    max = -1)
 }

 decompose_sessions <- function(df, ...){
   decompose(ts(df$sessions, frequency = 7))
 }

 decomp_ga <- ga_model_make(get_model_data,
                            required_columns = c("date", "sessions"),
                            model_f = decompose_sessions,
                            description = "Performs decomposition and creates plot")

 # fetches data and outputs decomposition
 ga_model(81416156, decomp_ga)

 # save the model for later
 model_location <- "decomp_ga.gamr"
 ga_model_save(decomp_ga, filename = model_location)

 # can load model from file
 ga_model(81416156, model_location)

 # or load model to an object and use 
 model2 <- ga_model_load(model_location)

 ga_model(81416156, model2)
 
 # for shiny include functions for the UI and server rendering
 decomp_ga <- ga_model_make(get_model_data,
                            required_columns = c("date", "sessions"),
                            model_f = decompose_sessions,
                            output_f = function(df, ...){graphics::plot(df)},
                            description = "Performs decomposition and creates a plot",
                            outputShiny = shiny::plotOutput,
                            renderShiny = shiny::renderPlot)

}
}
\seealso{
Other GA modelling functions: 
\code{\link{ga_model_edit}()},
\code{\link{ga_model_example}()},
\code{\link{ga_model_load}()},
\code{\link{ga_model_save}()},
\code{\link{ga_model_shiny_load}()},
\code{\link{ga_model_shiny_template}()},
\code{\link{ga_model_shiny}()},
\code{\link{ga_model_write}()},
\code{\link{ga_model}()}
}
\concept{GA modelling functions}
