% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customization.R
\name{customization}
\alias{customization}
\alias{make_prep}
\alias{make_check}
\title{Defining custom preparations and checks}
\usage{
make_prep(name, func)

make_check(description, check, gp, ...)
}
\arguments{
\item{name}{Name of the preparation function.}

\item{func}{A function that takes two arguments:
The \code{path} to the root directory of the package, and a logical
argument: \code{quiet}. If \code{quiet} is true, the preparation function
may print out diagnostic messages. The output of this function will be
saved as the " \code{name}" entry of \code{state}, i.e. of the input for
the  \code{check}-functions (see example).}

\item{description}{A description of the check.}

\item{check}{A function that takes the \code{state} as an argument.}

\item{gp}{A short description of what is good practice.}

\item{...}{Further arguments. Most important: A \code{preps} argument that
contains the names of all the preparation functions required for the check.}
}
\description{
Defining custom preparations and checks
}
\section{Functions}{
\itemize{
\item \code{make_prep}: Create a preparation function

\item \code{make_check}: Create a check function
}}

\examples{
# make a preparation function
url_prep <- make_prep(
  name = "desc", 
  func = function(path, quiet) desc::description$new(path)
)
# and the corresponding check function
url_chk <- make_check(
  description = "URL field in DESCRIPTION",
  tags = character(),
  preps = "desc",
  gp = "have a URL field in DESCRIPTION",
  check = function(state) state$desc$has_fields("URL")
)
# use together in gp():
# (note that you have to list the name of your custom check in
# the checks-argument as well....)
bad1 <- system.file("bad1", package = "goodpractice")
res <- gp(bad1, checks = c("url", "no_description_depends"),
          extra_preps = list("desc" = url_prep),
          extra_checks = list("url" = url_chk))
}
