% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules_fn.R
\name{module_template}
\alias{module_template}
\title{Golem Module Template Function}
\usage{
module_template(name, path, export, ph_ui = " ", ph_server = " ", ...)
}
\arguments{
\item{name}{The name of the module.}

\item{path}{The path to the R script where the module will be written.
Note that this path will not be set by the user but via
\code{add_module()}.}

\item{export}{Should the module be exported? Default is \code{FALSE}.}

\item{ph_ui, ph_server}{Texts to insert inside the modules UI and server.
For advanced use.}

\item{...}{Arguments to be passed to the \code{module_template} function.}
}
\value{
Used for side effect
}
\description{
Module template can be used to extend golem module creation
mechanism with your own template, so that you can be even more
productive when building your \code{{shiny}} app.
Module template functions do not aim at being called as is by
users, but to be passed as an argument to the \code{add_module()}
function.
}
\details{
Module template functions are a way to define your own template
function for module. A template function that can take the following
arguments to be passed from \code{add_module()}:
\itemize{
\item name: the name of the module
\item path: the path to the file in R/
\item export: a TRUE/FALSE set by the \code{export} param of \code{add_module()}
}

If you want your function to ignore these parameters, set \code{...} as the
last argument of your function, then these will be ignored. See the examples
section of this help.
}
\examples{

if (interactive()) {
  my_tmpl <- function(name, path, ...) {
    # Define a template that write to the
    # module file
    write(name, path)
  }
  golem::add_module(name = "custom", module_template = my_tmpl)

  my_other_tmpl <- function(name, path, ...) {
    # Copy and paste a file from somewhere
    file.copy(..., path)
  }
  golem::add_module(name = "custom", module_template = my_other_tmpl)
}
}
\seealso{
\code{\link[=add_module]{add_module()}}
}
