% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dockerfiles.R, R/add_dockerfiles_renv.R
\name{add_dockerfile}
\alias{add_dockerfile}
\alias{add_dockerfile_shinyproxy}
\alias{add_dockerfile_heroku}
\alias{add_dockerfile_with_renv}
\alias{add_dockerfile_with_renv_shinyproxy}
\alias{add_dockerfile_with_renv_heroku}
\title{Create a Dockerfile for your App}
\usage{
add_dockerfile(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/verse:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  port = 80,
  host = "0.0.0.0",
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)

add_dockerfile_shinyproxy(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/verse:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)

add_dockerfile_heroku(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/verse:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)

add_dockerfile_with_renv(
  source_folder = ".",
  lockfile = NULL,
  output_dir = fs::path(tempdir(), "deploy"),
  distro = "focal",
  from = "rocker/verse",
  as = NULL,
  sysreqs = TRUE,
  port = 80,
  host = "0.0.0.0",
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  extra_sysreqs = NULL,
  update_tar_gz = TRUE,
  dockerfile_cmd = NULL
)

add_dockerfile_with_renv_shinyproxy(
  source_folder = ".",
  lockfile = NULL,
  output_dir = fs::path(tempdir(), "deploy"),
  distro = "focal",
  from = "rocker/verse",
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  extra_sysreqs = NULL,
  open = TRUE,
  update_tar_gz = TRUE
)

add_dockerfile_with_renv_heroku(
  source_folder = ".",
  lockfile = NULL,
  output_dir = fs::path(tempdir(), "deploy"),
  distro = "focal",
  from = "rocker/verse",
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  extra_sysreqs = NULL,
  open = TRUE,
  update_tar_gz = TRUE
)
}
\arguments{
\item{path}{path to the DESCRIPTION file to use as an input.}

\item{output}{name of the Dockerfile output.}

\item{pkg}{Path to the root of the package. Default is \code{get_golem_wd()}.}

\item{from}{The FROM of the Dockerfile. Default is

\if{html}{\out{<div class="sourceCode">}}\preformatted{FROM rocker/verse

without renv.lock file passed
`R.Version()$major`.`R.Version()$minor` is used as tag
}\if{html}{\out{</div>}}}

\item{as}{The AS of the Dockerfile. Default it NULL.}

\item{port}{The \code{options('shiny.port')} on which to run the App.
Default is 80.}

\item{host}{The \code{options('shiny.host')} on which to run the App.
Default is 0.0.0.0.}

\item{sysreqs}{boolean. If TRUE, the Dockerfile will contain sysreq installation.}

\item{repos}{character. The URL(s) of the repositories to use for \code{options("repos")}.}

\item{expand}{boolean. If \code{TRUE} each system requirement will have its own \code{RUN} line.}

\item{open}{boolean. Should the Dockerfile/README be open after creation? Default is \code{TRUE}.}

\item{update_tar_gz}{boolean. If \code{TRUE} and \code{build_golem_from_source} is also \code{TRUE},
an updated tar.gz is created.}

\item{build_golem_from_source}{boolean. If \code{TRUE} no tar.gz is created and
the Dockerfile directly mount the source folder.}

\item{extra_sysreqs}{character vector. Extra debian system requirements.}

\item{source_folder}{path to the Package/golem source folder to deploy.
default is current folder '.'}

\item{lockfile}{path to the renv.lock file to use. default is \code{NULL}}

\item{output_dir}{folder to export everything deployment related.}

\item{distro}{One of "focal", "bionic", "xenial", "centos7", or "centos8".
See available distributions at https://hub.docker.com/r/rstudio/r-base/.}

\item{dockerfile_cmd}{What is the CMD to add to the Dockerfile. If NULL, the default,
the CMD will be \verb{R -e "options('shiny.port'=\{port\},shiny.host='\{host\}');\{appname\}::run_app()\\}}
}
\value{
The \code{{dockerfiler}} object, invisibly.
}
\description{
Build a container containing your Shiny App. \code{add_dockerfile()} and \code{add_dockerfile_with_renv()} creates
a generic Dockerfile, while \code{add_dockerfile_shinyproxy()}, \code{add_dockerfile_with_renv_shinyproxy()}  and
\code{add_dockerfile_heroku()} creates platform specific Dockerfile.
}
\examples{
\donttest{
# Add a standard Dockerfile
if (interactive() & requireNamespace("dockerfiler")) {
  add_dockerfile()
}
# Crete a 'deploy' folder containing everything needed to deploy
# the golem using docker based on {renv}
if (interactive() & requireNamespace("dockerfiler")) {
  add_dockerfile_with_renv(
    # lockfile = "renv.lock", # uncomment to use existing renv.lock file
    output_dir = "deploy"
  )
}
# Add a Dockerfile for ShinyProxy
if (interactive() & requireNamespace("dockerfiler")) {
  add_dockerfile_shinyproxy()
}

# Crete a 'deploy' folder containing everything needed to deploy
# the golem with ShinyProxy using docker based on {renv}
if (interactive() & requireNamespace("dockerfiler")) {
  add_dockerfile_with_renv(
    # lockfile = "renv.lock",# uncomment to use existing renv.lock file
    output_dir = "deploy"
  )
}

# Add a Dockerfile for Heroku
if (interactive() & requireNamespace("dockerfiler")) {
  add_dockerfile_heroku()
}
}
}
