% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{smart_df}
\alias{smart_df}
\title{Create random degrees of freedom parameter values close to given values}
\usage{
smart_df(
  M,
  df,
  accuracy,
  which_random = numeric(0),
  model = c("GMVAR", "StMVAR", "G-StMVAR")
)
}
\arguments{
\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMVAR type} components \code{M1}
   in the first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components
   is \code{M=M1+M2}.}
}}

\item{df}{the old degrees of freedom parameters (of all regimes)}

\item{accuracy}{a positive real number adjusting how close to the given degrees of freedom parameters
the returned df should be.}

\item{which_random}{a vector with length between 1 and M specifying the mixture components that should be random instead of
close to the given degrees of freedom.}

\item{model}{is "GMVAR", "StMVAR", or "G-StMVAR" model considered? In the G-StMVAR model, the first \code{M1} components
are GMVAR type and the rest \code{M2} components are StMVAR type.}
}
\value{
\describe{
    \item{\strong{GMVAR models}:}{a numeric vector of length zero.}
    \item{\strong{StMVAR models}:}{a numeric vector of length \code{M} with random entries strictly larger than two.}
    \item{\strong{G-StMVAR models}:}{a numeric vector of length \code{M2} with random entries strictly larger than two.}
  }
}
\description{
\code{random_df} generates random \code{M2} degrees of freedom parameter values
  close to given values, where \code{M2} is number of StMVAR type regimes in the model.
}
\keyword{internal}
