context("Functions in MAINest")
library(gmvarkit)

data <- cbind(10*eurusd[,1], 100*eurusd[,2])

test_that("get_minval works correctly", {
   expect_equal(get_minval(data), -99999)
   expect_equal(get_minval(cbind(rep(0, 1001), rep(0, 1001), rep(0, 1001))), -9999999)
})


params_122 <- c(1.273, 0.077, 0.954, 0.143, -0.013, 1.007, 2.437, 1.328, 5.331, 2.612,
                5.871, 0.96, -0.04, -0.016, 0.958, 7.527, 1.767, 10.702, 0.794)

C_mat <- rbind(diag(2*2^2), diag(2*2^2))
params_222c <- c(-0.2394, 1.62068, 0.80599, 2.52145, 1.11216, 0.0043, -0.00799, 1.3045,
                 -0.17324, -0.04317, 0.00787, -0.32015, 2.05112, 0.50578, 8.2455, 5.31921,
                 3.53916, 11.71524, 0.55429)

test_that("iterate_more works correctly", {
   gmvar122 <- iterate_more(GMVAR(data, p=1, M=2, d=2, params=params_122))
   expect_equal(gmvar122$params, c(0.61431227, -0.14506555, 0.95903463, 0.08923313, -0.00608985, 1.00609452, 1.74558443,
                                   0.80375069, 5.80320486, 3.24328578, 7.90873353, 0.95229396, -0.03711813, -0.01887533,
                                   0.9428667, 6.92512603, 3.97993189, 12.13192594, 0.80147446), tolerance=1e-5)

   gmvar222c <- iterate_more(GMVAR(data, p=2, M=2, d=2, params=params_222c, constraints=C_mat))
   expect_equal(gmvar222c$params, c(1.03113716, 2.35648836, 1.78577174, 3.00051297, 1.24966764, 0.05966373, 0.03647582,
                                    1.33533113, -0.29032713, -0.08312602, -0.04683255, -0.35637852, 0.93420712, -0.15163107,
                                    5.2014583, 5.88272302, 3.56025477, 9.79901012, 0.36803381), tolerance=1e-5)
})
