% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/music.R
\name{+.Music}
\alias{+.Music}
\title{Add Component to \code{Music} Object}
\usage{
\method{+}{Music}(music, term)
}
\arguments{
\item{music}{A \code{Music} object.}

\item{term}{A \code{Line}, \code{Meter}, \code{Key}, \code{Clef} or \code{Tempo} object.}
}
\value{
A list with class \code{Music}.
}
\description{
Add a component to a \code{Music} object.
}
\examples{
# initialize a Music object
m <- Music()

# add a Line object
m <- m + Line(list("C4"), list(1))
m

# add a Meter object
m <- m + Meter(4, 4)
m

# add a Key object
m <- m + Key(1)
m

# add a Clef object
m <- m + Clef("G", to = 1)
m

# add a Tempo object
m <- m + Tempo(120)
m
}
\seealso{
\code{\link[=Music]{Music()}} for initializing a \code{Music} object.

\code{\link[=Line]{Line()}}, \code{\link[=Meter]{Meter()}}, \code{\link[=Key]{Key()}}, \code{\link[=Clef]{Clef()}} and \code{\link[=Tempo]{Tempo()}}
for creating objects of corresponding classes.
}
