% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloss.R
\name{as_gloss}
\alias{as_gloss}
\title{Helper to create \code{gloss} objects}
\usage{
as_gloss(
  ...,
  source = NULL,
  translation = NULL,
  label = NULL,
  trans_quotes = getOption("glossr.trans.quotes", "\\""),
  output_format = getOption("glossr.output", "latex"),
  numbering = getOption("glossr.numbering", TRUE)
)
}
\arguments{
\item{...}{Lines for glossing}

\item{source}{(Optional) Source of example}

\item{translation}{(Optional) Free translation}

\item{label}{(Optional) Example label}

\item{trans_quotes}{(Optional) Quotes to surround the free translation with.}

\item{output_format}{(Optional) Whether it will use latex, word or html format.}

\item{numbering}{(Optional) Whether the gloss should be numbered (in Word and HTML).}
}
\value{
Object of class \code{\link[=new_gloss]{gloss}}, ready to be printed based on the chosen output format,
and with a \code{\link{gloss_data}} object as \code{data} attribute (or, in the case of calls via
\code{\link[=gloss_df]{gloss_df()}}, the original input as\code{data}).
}
\description{
Based on a character vectors and up to three label arguments,
create an object where those arguments are attributes.
These are:
\itemize{
\item \strong{source}: Where the text comes from. This will be printed in the first
line of the example, without word alignment.
\item \strong{translation}: Free translation. This will be printed as the last line
of the example, without word alignment and in quotation marks if so desired.
\item \strong{label}: Named label of the example, for cross-references.
\item \strong{lengths}: This is computed within the function, not provider, and
it's the number of items identified in each gloss line.
}
}
\examples{
ex_sp <- "Un ejemplo en español"
ex_gloss <- "DET.M.SG example in Spanish"
ex_trans <- "An example in Spanish"
my_gloss <- as_gloss(ex_sp, ex_gloss, translation = ex_trans, label="ex1")

# check the gloss data
attr(my_gloss, "data")
}
