% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_validate_files.R
\name{read_presences_absences_csv}
\alias{read_presences_absences_csv}
\title{Read and validate presences/absences CSV file}
\usage{
read_presences_absences_csv(
  file_path,
  file_name = NULL,
  show_modal = FALSE,
  coords = c("decimalLongitude", "decimalLatitude"),
  sep = "\\t",
  dec = "."
)
}
\arguments{
\item{file_path}{The file path to the CSV file.}

\item{file_name}{Optional. The name of the file. If not provided, the base name of the file path is used.}

\item{show_modal}{Optional. Logical. Whether to show a modal notification for warnings (use in Shiny). Default is FALSE.}

\item{coords}{Optional. Character vector of length 2 specifying the names of the columns containing the longitude and latitude coordinates. Default is c("decimalLongitude", "decimalLatitude").}

\item{sep}{Optional. The field separator character. Default is tab-separated.}

\item{dec}{Optional. The decimal point character. Default is ".".}
}
\value{
A data frame with the validated data if the file has the expected columns and formats, NULL otherwise.
}
\description{
This function reads and validates a CSV file containing presences and absences data for species occurrences.
It checks if the file has the expected columns and formats.
}
\keyword{internal}
