% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{BoxTidwell}
\alias{BoxTidwell}
\title{Box-Tidwell transformations}
\usage{
BoxTidwell(
  object,
  transf,
  epsilon = 1e-04,
  maxiter = 30,
  trace = FALSE,
  digits = getOption("digits") - 2,
  ...
)
}
\arguments{
\item{object}{a model fit object.}

\item{transf}{an one-sided formula giving the predictors that are candidates for transformation.}

\item{epsilon}{an (optional) numerical value. If the maximum relative change in coefficients is less than
\emph{epsilon}, then convergence is declared. By default, \emph{epsilon} is set to be 0.0001.}

\item{maxiter}{an (optional) positive integer value indicating the maximum number of iterations. By default,
\emph{maxiter} is set to be 30.}

\item{trace}{an (optional) logical indicating if should the record of iterations be printed. By default,
\emph{trace} is set to be FALSE.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Two matrices with the values of marginal and omnibus tests.
}
\description{
Computes the Box-Tidwell power transformations of the predictors in a regression model.
}
