% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{depression}
\alias{depression}
\title{Treatment for severe postnatal depression}
\format{
A data frame with 427 rows and 5 variables:
\describe{
  \item{subj}{ a numeric vector giving the identifier of each woman.}
  \item{group}{ a factor giving the received treatment: "placebo" or "oestrogen".}
  \item{visit}{ a numeric vector giving the number of months since the treatment began, where -1 indicates the pretreatment assessment of the EDPS.}
  \item{dep}{ a numeric vector giving the value of the EDPS.}
  \item{depressd}{ a numeric vector coded as 1 when the value of the EDPS is greater than or equal to 11 and coded as 0 in other cases.}
}
}
\source{
\url{https://stats.oarc.ucla.edu/spss/library/spss-librarypanel-data-analysis-using-gee/}
}
\usage{
data(depression)
}
\description{
These data arose from a study on the efficacy of
oestrogen give transdermally for treatment of severe postnatal
depression. Women with major depression were randomly assigned
to either a placebo control group or estrogen patch group.
Prior to the treatment all women were assessed by
self-ratings of depressive symptoms on the Edinburgh
Postnatal Depression Scale (EPDS). The data on EPDS were
collected monthly for six months once the treatment began.
Higher scores on the EDPS are indicative of higher levels of
depression.
}
\examples{
data(depression)
dev.new()
boxplot(dep ~ visit, data=subset(depression,group=="placebo"), at=c(0:6) - 0.2,
        col="yellow", boxwex=0.3, xaxt="n", ylim=range(na.omit(depression$dep)),
        xlab="Months since the treatment began", ylab="EDPS")
boxplot(dep ~ visit, data=subset(depression,group=="oestrogen"), add=TRUE,
        at=c(0:6) + 0.2, col="blue", boxwex=0.3, xaxt="n")
axis(1, at=c(0:6), labels=c(-1,1:6))
legend("bottomleft", legend=c("placebo","oestrogen"), fill=c("yellow","blue"),
       title="Treatment", bty="n")

}
\references{
Gregoire A.J.P., Kumar R., Everitt B., Henderson A.F., Studd, J.W.W. (1996) Transdermal oestrogen for treatment of severe postnatal depression,
\emph{The Lancet} 347:930-933.
}
\keyword{datasets}
