% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{residuals.overglm}
\alias{residuals.overglm}
\title{Residuals for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion.}
\usage{
\method{residuals}{overglm}(
  object,
  type = c("quantile", "standardized", "response"),
  plot.it = FALSE,
  identify,
  ...
)
}
\arguments{
\item{object}{an object of class \emph{overglm}.}

\item{type}{an (optional) character string which allows to specify the required type of residuals. The available options are: (1)
the difference between the observed response and the fitted mean ("response"); (2) the standardized difference between
the observed response and the fitted mean ("standardized"); and (3) the randomized quantile residual ("quantile"). By
default, \code{type} is set to be "quantile".}

\item{plot.it}{an (optional) logical switch indicating if the plot of residuals versus the fitted values is required. By default, \code{plot.it} is set to be FALSE.}

\item{identify}{an (optional) positive integer value indicating the number of individuals to identify on the plot of residuals versus the fitted values. This is only appropriate if \code{plot.it=TRUE}.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE} then \code{...} may be used to include graphical parameters to customize the plot. For example, \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A vector with the observed \code{type}-type residuals.
}
\description{
Computes various types of residuals to assess the individual quality of model fit for
regression models based on the negative binomial, beta-binomial, and random-clumped binomial
distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
}
\examples{
###### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
residuals(fit1, type="quantile", plot.it=TRUE, col="red", pch=20, col.lab="blue",
          col.axis="blue", col.main="black", family="mono", cex=0.8)

###### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
residuals(fit2, type="quantile", plot.it=TRUE, col="red", pch=20, col.lab="blue",
          col.axis="blue", col.main="black", family="mono", cex=0.8)

###### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)
residuals(fit3, type="quantile", plot.it=TRUE, col="red", pch=20, col.lab="blue",
          col.axis="blue", col.main="black", family="mono", cex=0.8)

}
\references{
Dunn P.K. and Smyth G.K. (1996) Randomized Quantile Residuals. \emph{Journal of Computational and Graphical Statistics}, 5, 236-244.
}
