% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{stepCriterion.overglm}
\alias{stepCriterion.overglm}
\title{Variable selection for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion}
\usage{
\method{stepCriterion}{overglm}(
  model,
  criterion = c("bic", "aic", "p-value"),
  test = c("wald", "score", "lr", "gradient"),
  direction = c("forward", "backward"),
  levels = c(0.05, 0.05),
  trace = TRUE,
  scope,
  ...
)
}
\arguments{
\item{model}{an object of the class \emph{overglm}.}

\item{criterion}{an (optional) character string which allows to specify the criterion which should be used to compare the
candidate models. The available options are: AIC ("aic"), BIC ("bic"), and \emph{p}-value of the \code{test}-type test
("p-value"). As default, \code{criterion} is set to "bic".}

\item{test}{an (optional) character string which allows to specify the statistical test which should be used to compare nested
models. The available options are: Wald ("wald"), Rao's score ("score"), likelihood-ratio ("lr") and gradient
("gradient") tests. As default, \code{test} is set to "wald".}

\item{direction}{an (optional) character string which allows to specify the type of procedure which should be used. The available
options are: hybrid backward stepwise ("backward") and hybrid forward stepwise ("forward"). As default, \code{direction}
is set to "forward".}

\item{levels}{an (optional) two-dimensional vector of values in the interval \eqn{(0,1)} indicating the levels at which
the variables should in and out from the model. This is only appropiate if \code{criterion}="p-value". By default,
\code{levels} is set to \code{c(0.05,0.05)}.}

\item{trace}{an (optional) logical switch indicating if should the stepwise reports be printed. By default,
\code{trace} is set to TRUE.}

\item{scope}{an (optional) list, containing components \code{lower} and \code{upper}, both formula-type objects,
indicating the range of models which should be examined in the stepwise search. As default, \code{lower} is a model
with no predictors and \code{upper} is the linear predictor of the model in \code{model}.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the
penalty in the AIC, which by default is set to 2.}
}
\value{
A list which contains the following objects:
\tabular{ll}{
\code{initial} \tab a character string indicating the linear predictor of the "initial model",\cr
\tab \cr
\code{direction}\tab a character string indicating the type of procedure which was used,\cr
\tab \cr
\code{criterion}\tab a character string indicating the criterion used to compare the candidate models,\cr
\tab \cr
\code{final}\tab a character string indicating the linear predictor of the "final model",\cr
}
}
\description{
Performs variable selection using hybrid versions of forward stepwise and backward stepwise by comparing
hierarchically builded candidate models using a criterion previously specified such as AIC, BIC or \eqn{p}-value of the
significance tests.
}
\examples{
###### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ age + gender + frequency + location, family="nb1(log)", data=swimmers)

stepCriterion(fit1, criterion="p-value", direction="forward", test="lr")

stepCriterion(fit1, criterion="bic", direction="backward", test="score")

###### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + mar + kid5 + phd + ment, family="nb1(log)", data = bioChemists)

stepCriterion(fit2, criterion="p-value", direction="forward", test="lr")

stepCriterion(fit2, criterion="bic", direction="backward", test="score")

###### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn + tnf*ifn, family="bb(logit)", data=cellular)

stepCriterion(fit3, criterion="p-value", direction="backward", test="lr")

stepCriterion(fit3, criterion="bic", direction="forward", test="score")

}
\references{
James G., Witten D., Hastie T., Tibshirani R. (2013, page 210) An Introduction to Statistical Learning
with Applications in R. Springer, New York.
}
\seealso{
\link{stepCriterion.lm}, \link{stepCriterion.glm}, \link{stepCriterion.glmgee}
}
