% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bin_data}
\alias{bin_data}
\title{A simulated binomial data set.}
\format{
A list with three elements: design matrix \code{X}, response \code{y}, 
  and the true coefficient vector \code{beta}.
\describe{
  \item{X}{design matrix}
  \item{y}{response}
  \item{beta}{the true coefficient vector}
}
}
\usage{
data(bin_data)
}
\description{
A data set simulated for illustrating logistic regression models. Generated by 
  \code{gen.binomial.data(n = 200, p = 20, seed = 2021)}.
}
\examples{
data("bin_data")
cv.fit <- cv.glmtlp(bin_data$X, bin_data$y, family = "binomial", penalty = "l1")
plot(cv.fit)

}
\keyword{datasets}
