% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_u_samples.R
\name{gen_u_samples}
\alias{gen_u_samples}
\title{Generate samples of random effects using MCMC}
\usage{
gen_u_samples(y, X, Z, L, beta, family, sigma = 1, warmup_iter = 100, m = 100)
}
\arguments{
\item{y}{Vector of outcomes}

\item{X}{Matrix of covariates}

\item{Z}{Matrix, the design matrix of the random effects}

\item{L}{Matrix, the Cholesky decomposition of the covariance matrix of the random effects}

\item{beta}{Vector of mean function parameters}

\item{family}{A family function, e.g. gaussian()}

\item{sigma}{Numeric, the scale parameter of the distribution}

\item{warmup_iter}{Numeric, the number of warmup iterations}

\item{m}{Numeric, the number of sampling iterations}
}
\value{
A matrix in which each column is a sample of the random effects
}
\description{
Generate samples of random effects using MCMC
}
\details{
Calls Stan through `cmdstanr` to generate `m` samples of the random effects from
a GLMM conditional on fixed values of the model parameters. To make use of 
parallelisation, the model is parameterised in terms of the Cholesky decomposition
of the covariance matrix of the random effects. Only a single chain is run to generate 
the samples.
}
\examples{
\dontrun{
## small example with simulated data
df <- nelder(~(j(10) * t(3)) > i(5))
des <- ModelMCML$new(
 covariance = list(
  formula =  ~(1|gr(j)*ar1(t)),
  parameters = c(0.25,0.7)
),
mean = list(
  formula = ~factor(t)-1,
  parameters = rnorm(3)
),
data=df,
family=gaussian()
)
## simulate data
y <- des$sim_data()
## get covariance definition matrix
ddata <- des$covariance$get_D_data()
## simulate some values of the random effects
## first, we need to extract the Cholesky decomposition of the covariance matrix D
L <- des$covariance$get_chol_D()
samp <- gen_u_samples(y=y,
  Z = as.matrix(des$covariance$Z),
  L = as.matrix(L),
  X = as.matrix(des$mean_function$X),
  beta = des$mean_function$parameters,,
  family = des$mean_function$family
 )
}
}
