% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcn.R
\name{coef.cv_glmaag}
\alias{coef.cv_glmaag}
\title{Coefficients}
\usage{
\method{coef}{cv_glmaag}(object, type1se = T, ...)
}
\arguments{
\item{object}{the estimated cv_glmaag model}

\item{type1se}{whether or not used 1 SE error (default to be TRUE)}

\item{...}{\dots}
}
\value{
estimated coefficient included intercept (Cox model does not return intercept)
}
\description{
Get the coefficients estimated by the cv_glmaag model
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
cvwhich <- sample(rep(0:4, length.out = length(y)))
mod <- cv_glmaag(y, x, L0, cvwhich = cvwhich)
cc <- coef(mod)
}
