% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VP.gllvm.R, R/plotVP.gllvm.R
\name{VP.gllvm}
\alias{VP.gllvm}
\alias{varPartitioning.gllvm}
\alias{VP}
\alias{varPartitioning}
\alias{print.VP.gllvm}
\alias{plotVarPartitioning}
\alias{plotVP}
\alias{plot.VP.gllvm}
\title{Calculate variance partitioning}
\usage{
\method{VP}{gllvm}(
  object,
  group = NULL,
  groupnames = NULL,
  adj.cov = TRUE,
  grouplvs = FALSE,
  ...
)

\method{print}{VP.gllvm}(x, ...)

plotVarPartitioning(
  x,
  main = "Variance Partitioning",
  xlab = "Response",
  ylab = "Variance proportion",
  legend.text = NULL,
  args.legend = list(cex = 0.7, x = "topright", bty = "n", inset = c(0, -0.15)),
  mar = c(4, 4, 6, 2),
  ...
)

plotVP(x, ...)

\method{plot}{VP.gllvm}(x, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{group}{a vector of integers identifying grouping of X covariates, the default is to use model terms formula and lv.formula.}

\item{groupnames}{a vector of strings given as names for the groups defined in group}

\item{adj.cov}{logical, whether or not to adjust co-variation within the group}

\item{grouplvs}{logical, whether or not to group latent variables to one group}

\item{...}{additional graphical arguments passed to the barplot function}

\item{x}{a variance partitioning object for a gllvm produced by function varPartitioning.}

\item{main}{main title}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{legend.text}{a vector of names for the groups, as a default 'groupnames' from varPartitioning. If FALSE, legend not printed.}

\item{args.legend}{a list of additional arguments to pass to \code{legend()}.}

\item{mar}{Margins of the plot. Default \code{c(4,4,6,2)}}
}
\description{
Calculates variance partitioning for gllvm object with function \code{VP()} (alias \code{varPartitioning()}).

Function \code{plotVarPartitioning()} (alias \code{plotVP()} or just \code{plot()}) plots the results of variance partitioning of a fitted gllvm.
}
\details{
Variance for the linear predictor for response j can be calculated as 

 \deqn{Var(\eta_j) = \sum_k \beta_{jk}^2*var(z_{.k}) + 2 \sum_{(k1=1,...,K-1)} \sum_{(k2=k1+1,...,K)}  \beta_{j(k1)}\beta_{j(k2)} Cov(Z_{.k1},Z_{.k2}) , }
 
where \eqn{z_{.k}} is a vector consisting of predictor/latent variable/row effect etc values for all sampling units i.
If \eqn{z_{.k}}s are not correlated, covariance term is 0 and thus the variance explained of a response j for predictor \eqn{z_{.k}} is given as \eqn{\beta_{jk}^2*var(z_{.k})/Var(\eta_j)}.

In case of correlated predictors, it is advised to group them into a same group. The variance explained is calculated for the correlated group of predictors together and adjusted with the covariance term.
}
\examples{
# Extract subset of the microbial data to be used as an example
data(microbialdata)
X <- microbialdata$Xenv
y <- microbialdata$Y[, order(colMeans(microbialdata$Y > 0), 
                     decreasing = TRUE)[21:40]]
fit <- gllvm(y, X[,1:3], formula = ~ pH + Phosp, family = poisson(), 
             studyDesign = X[,4:5], row.eff = ~(1|Site))
VP <- VP(fit)
plot(VP)

\dontrun{
# Plot the result of  variance partitioning
plot(VP, col = palette(hcl.colors(5, "Roma")))

}

}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>
}
