% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.gllvm.R
\name{se.gllvm}
\alias{se.gllvm}
\alias{se}
\title{Standard errors for gllvm model}
\usage{
\method{se}{gllvm}(object, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{...}{not used.}
}
\value{
\item{sd }{ list of standard errors of parameters}
 \item{Hess }{ list including Hessian matrix and approximative covariance matrix of parameters}
}
\description{
Calculates Hessian and standard errors for gllvm model.
}
\details{
Computes Hessian and standard errors for gllvm model.
}
\examples{
data(spider)
mod <- gllvm(spider$abund, num.lv = 2, family = "poisson", sd.errors = FALSE)
# Calculate standard errors after fitting
sdErr <- se(mod)
# Store the standard errors in the right place
mod$sd <-sdErr$sd
# Store the Hessian in the right place
mod$Hess <- sdErr$Hess
}
\references{
Dunn, P. K., and Smyth, G. K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics, 5, 236-244.

Hui, F. K. C., Taskinen, S., Pledger, S., Foster, S. D., and Warton, D. I. (2015).  Model-based approaches to unconstrained ordination. Methods in Ecology and Evolution, 6:399-411.
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>
}
