% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glca.gof.R
\name{glca.gof}
\alias{glca.gof}
\title{Goodness of Fit Tests for Fitted \code{glca} Model}
\usage{
glca.gof(
  object,
  ...,
  test = NULL,
  nboot = 50,
  random.seed = NULL,
  criteria = c("logLik", "AIC", "CAIC", "BIC", "entropy"),
  maxiter = 500,
  eps = 1e-04,
  verbose = FALSE
)
}
\arguments{
\item{object}{an object of "\code{glca}", usually, a result of a call to \code{glca}}

\item{...}{an optional object of "\code{glca}" to be compared with \code{object}}

\item{test}{a character string indicating type of test (chi-square test or bootstrap) to obtain the p-value for goodness of fit test (\code{"chisq"} or \code{"boot"})}

\item{nboot}{number of bootstrap samples, only used when \code{test = "boot"}}

\item{random.seed}{random seed to have the equivalent solution for every bootstrap trials}

\item{criteria}{a character vector indicating criteria to be printed.}

\item{maxiter}{an integer for maximum number of iteration for bootstrap sample}

\item{eps}{positive convergence tolerance for bootstrap sample}

\item{verbose}{an logical value for whether or not to print the result of a function's execution}
}
\value{
\item{gtable}{a matrix with model goodneess-of-fit criteria}
\item{dtable}{a matrix with deviance statistic and bootstrap p-value}
\item{boot}{a list of LRT statistics from each bootstrap sample}

\code{gtable}, which is always included in output of this function, includes goodness-of-fit criteria which are indicated \code{criteria} arguments for the \code{object}(s). \code{dtable} are contained when the \code{object}s are competing models. (when used items of the models are identical) \code{dtable} prints deviance and p-value. (bootstrap or chi-square) Lastly, when the boostrap sample is used, the \code{G^2}-statistics for each bootstrap samples will be included in return object..
}
\description{
Provides AIC, CAIC, BIC, entropy and deviance statitistic for goodness of fit test for the fitted model. Given \code{object2}, the function computes the log-likelihood ratio (LRT) statisic for comparing the goodness of fit for two models. The bootstrap p-value can be obtained from the empirical distribution of LRT statistic by choosing \code{test = "boot"}.
}
\examples{
## Example 1.
## Model selection between two LCA models with different number of latent classes.
data(gss08)
class2 = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
              data = gss08, nclass = 2)
class3 = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
              data = gss08, nclass = 3)
class4 = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
              data = gss08, nclass = 4)

glca.gof(class2, class3, class4)
\dontrun{glca.gof(class2, class3, class4, test = "boot")}

## Example 2.
## Model selection between two MLCA models with different number of latent clusters.
cluster2 = glca(item(ECIGT, ECIGAR, ESLT, EELCIGT, EHOOKAH) ~ 1,
                group = SCH_ID, data = nyts18, nclass = 2, ncluster = 2)
cluster3 = glca(item(ECIGT, ECIGAR, ESLT, EELCIGT, EHOOKAH) ~ 1,
                group = SCH_ID, data = nyts18, nclass = 2, ncluster = 3)

glca.gof(cluster2, cluster3)
\dontrun{glca.gof(cluster2, cluster3, test = "boot")}

\donttest{
## Example 3.
## MGLCA model selection under the measurement (invariance) assumption across groups.
measInv = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
               group = DEGREE, data = gss08, nclass = 3)
measVar = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
               group = DEGREE, data = gss08, nclass = 3, measure.inv = FALSE)

glca.gof(measInv, measVar)
glca.gof(measInv, measVar, test = "chisq")
}
}
\references{
Akaike, H. (1974) A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control}, \bold{19}, 716–723. \doi{10.1109/tac.1974.1100705}

Schwarz, G. (1978) Estimating the dimensions of a model. \emph{The Annals of Statistics}, \bold{6}, 461–464. \doi{10.1214/aos/1176344136}

Langeheine, R., Pannekoek, J., and van de Pol, F. (1996) Bootstrapping goodness-of-fit measures in categorical data analysis. \emph{Sociological Methods and Research}. \bold{24}. 492-516. \doi{10.1177/0049124196024004004}

Ramaswamy, V., Desarbo, W., Reibstein, D., & Robinson, W. (1993). An Empirical Pooling Approach for Estimating Marketing Mix Elasticities with PIMS Data. Marketing Science, 12(1), 103-124. \doi{10.1287/mksc.12.1.103}
}
\seealso{
\code{\link{glca}} \code{\link{gss08}} \code{\link{nyts18}}
}
\author{
Youngsun Kim
}
