% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterizeGimms.R
\name{rasterizeGimms}
\alias{rasterizeGimms}
\title{Rasterize GIMMS NDVI3g Data}
\usage{
rasterizeGimms(x, ext = NULL, snap = "out", keep = NULL, split = FALSE,
  cores = 1L, filename = "", ...)
}
\arguments{
\item{x}{\code{character}. Vector of local filepaths. Note that product
versions must not be mixed, i.e. 'x' should represent files originating from
either NDVI3g.v1 or NDVI3g.v0 only.}

\item{ext}{\code{Extent}, or any object from which an \code{Extent} can be
extracted, see \code{\link[raster]{crop}}.}

\item{snap}{\code{character}, defaults to "out". Other available options are
"in" and "near", see \code{\link[raster]{crop}}.}

\item{keep}{\code{integer}. Flag values of NDVI3g pixels to spare during
quality control. Pixels with non-included flag values are set to \code{NA}.
If not specified (i.e., \code{NULL}; default), quality control is skipped.}

\item{split}{\code{logical}, defaults to \code{FALSE}. If \code{TRUE}, a
\code{list} of \code{RasterStack} objects (of \code{length(x)}) is returned
rather than a single \code{RasterStack}.}

\item{cores}{\code{integer}. Number of cores for parallel computing.}

\item{filename}{\code{character}. Optional output filename. If specified,
this must be of the same length as 'x'.}

\item{...}{Further arguments passed to \code{\link{writeRaster}}.}
}
\value{
If \code{split = TRUE}, a list of NDVI3g \code{RasterStack} objects
corresponding to the files specified in 'x'; else a single NDVI3g
\code{RasterStack} object.
}
\description{
Import GIMMS NDVI3g (binary or NetCDF) data into R as \code{Raster*} objects.
}
\examples{
\dontrun{
tmp <- tempdir()

## Download NDVI3g.v1 sample data
gimms_files <- downloadGimms(x = as.Date("2000-01-01"),
                             y = as.Date("2000-12-31"),
                             dsn = tmp)

## Extent for clipping
shp <- getData("GADM", country = "DEU", level = 0, path = tmp)

## Rasterize without quality control
gimms_raster <- rasterizeGimms(x = gimms_files,
                               ext = shp) # clipping
plot(gimms_raster[[1]])
lines(shp)

## Rasterize with quality control
gimms_rasterq <- rasterizeGimms(x = gimms_files,
                                ext = shp, # clipping
                                keep = 0)  # quality control
plot(gimms_rasterq[[1]])
lines(shp)
}

}
\seealso{
\code{\link[raster]{crop}}, \code{\link{qualityControl}},
\code{\link{writeRaster}}.
}
