% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_repo.R, R/local_repo_add.R,
%   R/local_repo_branch.R, R/local_repo_clone.R, R/local_repo_commit.R,
%   R/local_repo_log.R, R/local_repo_pull.R, R/local_repo_push.R
\name{local_repo}
\alias{local_repo}
\alias{local_repo_add}
\alias{local_repo_branch}
\alias{local_repo_clone}
\alias{repo_clone}
\alias{local_repo_commit}
\alias{local_repo_log}
\alias{local_repo_pull}
\alias{local_repo_push}
\title{Functions for managing local git repositories}
\usage{
local_repo_add(repo_dir, files = ".")

local_repo_branch(repo_dir, branch)

local_repo_clone(
  repo,
  local_path = ".",
  branch = NULL,
  mirror = FALSE,
  verbose = FALSE
)

local_repo_commit(repo_dir, message)

local_repo_log(repo_dir, max = 100)

local_repo_pull(repo_dir, verbose = FALSE)

local_repo_push(
  repo_dir,
  remote = "origin",
  branch = NULL,
  force = FALSE,
  prompt = TRUE,
  mirror = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{repo_dir}{Vector of repo directories or a single directory containing one or more repos.}

\item{files}{Files to be staged}

\item{branch}{Repository branch to use.}

\item{repo}{GitHub repo address with the form \code{owner/name}.}

\item{local_path}{Local directory to store cloned repos.}

\item{mirror}{Equivalent to \code{--mirror}}

\item{verbose}{Display verbose output.}

\item{message}{Commit message}

\item{max}{Maximum number of log entries to retrieve per repo.}

\item{remote}{Repository remote to use.}

\item{force}{Force push?}

\item{prompt}{Prompt before force push?}
}
\value{
\code{local_repo_clone()} invisibly returns a character vector of paths for
the local repo directories.

\code{local_repo_log()} returns a tibble containing repository details.`

All other functions invisibly return a list containing the results of the relevant call
to \code{gert}.
}
\description{
\itemize{
\item \code{local_repo_clone()} - Clones a GitHub repository to a local directory.
\item \code{local_repo_add()} - Equivalent to \verb{git add} - stages a file in a local repository.
\item \code{local_repo_commit()} - Equivalent to \verb{git commit} - commits staged files in a local repository.
\item \code{local_repo_push()} - Equivalent to \verb{git push} - push a local repository.
\item \code{local_repo_pull()} - Equivalent to \verb{git pull} - pull a local repository.
\item \code{local_repo_branch()} - Equivalent to \verb{git branch} - create a branch in a local repository.
\item \code{local_repo_log()} - Equivalent to \verb{git log} - returns a data frame for git log entries.
}
}
\details{
All \verb{local_repo_*} functions depend on the \code{gert} library being installed.
}
\examples{
\dontrun{
repo = repo_create("ghclass-test", "local_repo_test")

dir = file.path(tempdir(), "repos")
local_repo = local_repo_clone(repo, dir)

local_repo_log(dir)

# Make a local change and push
writeLines("Hello World", file.path(local_repo, "hello.txt"))

local_repo_add(local_repo, "hello.txt")

local_repo_commit(local_repo, "Added hello world")

local_repo_push(local_repo)

repo_commits(repo)

# Pulling remote changes
repo_modify_file(repo, "hello.txt", pattern = ".*",  content = "!!!", method = "after")

local_repo_pull(local_repo)

local_repo_log(dir)

repo_delete("ghclass-test/local_repo_test", prompt=FALSE)
}

}
